/*
 * Decompiled with CFR 0.152.
 */
package model;

import controller.DuelsEvaluator;
import controller.Main;
import javafx.application.Platform;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import model.Player;
import model.RandomUtil;
import model.Team;

public class GameAutomaton
extends Thread {
    private Team team1;
    private Team team2;
    private RandomUtil rand;
    private Label lb_goals_team1;
    private Label lb_goals_team2;
    private Label lb_poss_team1;
    private Label lb_poss_team2;
    private Label lb_shots_off_target_team1;
    private Label lb_shots_off_target_team2;
    private Label lb_shots_on_target_team1;
    private Label lb_shots_on_target_team2;
    private Label lb_attempted_passes_team1;
    private Label lb_attempted_passes_team2;
    private Label lb_successful_passes_team1;
    private Label lb_successful_passes_team2;
    private Label lb_tackles_team1;
    private Label lb_tackles_team2;
    private Label lb_fouls_team1;
    private Label lb_fouls_team2;
    private Label lb_interceptions_team1;
    private Label lb_interceptions_team2;
    private Label lb_minute;
    private Label lb_corners_team1;
    private Label lb_corners_team2;
    private TextArea ta_commentary;
    private TextArea ta_scorers;
    private int goalsTeam1;
    private int goalsTeam2;
    private int possTeam1;
    private int possTeam2;
    private int shotsOffTeam1;
    private int shotsOffTeam2;
    private int shotsOnTeam1;
    private int shotsOnTeam2;
    private int foulsTeam1;
    private int foulsTeam2;
    private int tacklesTeam1;
    private int tacklesTeam2;
    private int succPassesTeam1;
    private int succPassesTeam2;
    private int attPassesTeam1;
    private int attPassesTeam2;
    private int interceptTeam1;
    private int interceptTeam2;
    private int gameMinutes = 0;
    private int attemptedDribbles1;
    private int attemptedDribbles2;
    private int successfulDribbles1;
    private int successfulDribbles2;
    private int corners1;
    private int corners2;
    private float probabilityCorner;
    private float probabilityInterception;
    private float probabilityFoul;
    private int automatonIterations;
    private int teamAIterations;
    private int teamBIterations;
    private state automatonState;
    private DuelsEvaluator duelsEvaluator;

    public void bindCommentaryBox(TextArea ta_commentary) {
        this.ta_commentary = ta_commentary;
    }

    public void bindListViewsScorers(TextArea ta_scorers) {
        this.ta_scorers = ta_scorers;
    }

    public GameAutomaton(Team team1, Team team2) {
        this.team1 = team1;
        this.team2 = team2;
        this.initializeProperties();
        this.automatonState = state.initialState;
        this.duelsEvaluator = new DuelsEvaluator();
        this.rand = new RandomUtil();
        this.probabilityCorner = (float)this.rand.getFromInterval(15, 26) * 1.0f / 100.0f;
        this.probabilityInterception = (float)this.rand.getFromInterval(15, 30) * 1.0f / 100.0f;
        this.probabilityFoul = (float)this.rand.getFromInterval(15, 30) * 1.0f / 100.0f;
        this.automatonIterations = 1;
        this.teamAIterations = 1;
        this.teamBIterations = 1;
    }

    private void refreshGui() {
        this.updateOnGui(this.lb_goals_team1, this.goalsTeam1);
        this.updateOnGui(this.lb_attempted_passes_team1, this.attPassesTeam1);
        this.updateOnGui(this.lb_successful_passes_team1, this.succPassesTeam1);
        this.updateOnGui(this.lb_fouls_team1, this.foulsTeam1);
        this.updateOnGui(this.lb_interceptions_team1, this.interceptTeam1);
        this.updateOnGui(this.lb_poss_team1, Math.round((float)this.teamAIterations * 1.0f / (float)this.automatonIterations * 100.0f));
        this.updateOnGui(this.lb_shots_on_target_team1, this.shotsOnTeam1);
        this.updateOnGui(this.lb_shots_off_target_team1, this.shotsOffTeam1);
        this.updateOnGui(this.lb_tackles_team1, this.tacklesTeam1);
        this.updateOnGui(this.lb_goals_team2, this.goalsTeam2);
        this.updateOnGui(this.lb_attempted_passes_team2, this.attPassesTeam2);
        this.updateOnGui(this.lb_successful_passes_team2, this.succPassesTeam2);
        this.updateOnGui(this.lb_fouls_team2, this.foulsTeam2);
        this.updateOnGui(this.lb_interceptions_team2, this.interceptTeam2);
        this.updateOnGui(this.lb_poss_team2, 100 - Math.round((float)this.teamAIterations * 1.0f / (float)this.automatonIterations * 100.0f));
        this.updateOnGui(this.lb_shots_on_target_team2, this.shotsOnTeam2);
        this.updateOnGui(this.lb_shots_off_target_team2, this.shotsOffTeam2);
        this.updateOnGui(this.lb_tackles_team2, this.tacklesTeam2);
        this.updateOnGui(this.lb_minute, this.gameMinutes);
        this.updateOnGui(this.lb_corners_team1, this.corners1);
        this.updateOnGui(this.lb_corners_team2, this.corners2);
        this.updateOnGui(this.ta_commentary, DuelsEvaluator.CommentaryMsg);
    }

    private void updateOnGui(Label someLabel, int value) {
        Platform.runLater(() -> someLabel.setText(value + ""));
    }

    private void updateOnGui(TextArea commentary, String msg) {
        Platform.runLater(() -> commentary.appendText(msg + "\n"));
    }

    private void updateOnGui(Label someLabel, float value) {
        Platform.runLater(() -> someLabel.setText(value + ""));
    }

    private void initializeProperties() {
    }

    public Team getTeam1() {
        return this.team1;
    }

    public Team getTeam2() {
        return this.team2;
    }

    @Override
    public void run() {
        while (this.gameMinutes < 90) {
            try {
                Thread.sleep(Main.MillisecondsForOneMinute);
                Platform.runLater(() -> this.lb_minute.setText(this.gameMinutes + ""));
                this.nextMinute();
                this.simulate(this.rand.getFromInterval(2, 9));
            }
            catch (InterruptedException e) {
                System.out.println("");
            }
        }
        System.out.println("Game has ended");
        System.out.println(this.team1.getTeamName() + " " + this.goalsTeam1 + "\t" + this.team2.getTeamName() + " " + this.goalsTeam2);
    }

    private void simulate(int n) {
        if (this.gameMinutes == 90) {
            this.automatonState = state.finalState;
            return;
        }
        if (this.gameMinutes == 45) {
            this.automatonState = state.halfTimeState;
            System.out.println("Half time!");
            return;
        }
        block16: for (int i = 0; i < n; ++i) {
            ++this.automatonIterations;
            switch (this.automatonState) {
                case initialState: {
                    this.automatonState = state.possessionA;
                    continue block16;
                }
                case halfTimeState: {
                    this.automatonState = state.possessionB;
                    continue block16;
                }
                case possessionA: {
                    this.automatonState = this.handlePossessionState(this.automatonState);
                    continue block16;
                }
                case possessionB: {
                    this.automatonState = this.handlePossessionState(this.automatonState);
                    continue block16;
                }
                case goalA: {
                    this.handleGoalAction(1);
                    continue block16;
                }
                case goalB: {
                    this.handleGoalAction(2);
                    continue block16;
                }
                case dribbleA: {
                    this.handleDribbleAction(1);
                    continue block16;
                }
                case dribbleB: {
                    this.handleDribbleAction(2);
                    continue block16;
                }
                case passA: {
                    this.handlePassingAction(1);
                    continue block16;
                }
                case passB: {
                    this.handlePassingAction(2);
                    continue block16;
                }
                case shootA: {
                    this.handleShootingAction(1);
                    continue block16;
                }
                case shootB: {
                    this.handleShootingAction(2);
                    continue block16;
                }
                case cornerA: {
                    this.handleCornerAction(1);
                    continue block16;
                }
                case cornerB: {
                    this.handleCornerAction(2);
                    continue block16;
                }
                default: {
                    System.out.println("STUCK ON DEFAULT: Current state:" + (Object)((Object)this.automatonState));
                    return;
                }
            }
        }
        this.refreshGui();
    }

    private void handleCornerAction(int teamNumber) {
        if (teamNumber == 1) {
            ++this.teamAIterations;
            Player setPieceTaker = this.team1.getSetPieceTaker();
            float res = this.duelsEvaluator.tryCorner(setPieceTaker);
            ++this.corners1;
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.shotsOnTeam1;
                this.automatonState = state.goalA;
                this.duelsEvaluator.setLastScorer(this.team1.getDefender());
            } else {
                res = this.rand.runif();
                this.automatonState = res <= 0.5f ? state.possessionA : state.possessionB;
            }
        } else {
            ++this.teamBIterations;
            Player setPieceTaker = this.team2.getSetPieceTaker();
            float res = this.duelsEvaluator.tryCorner(setPieceTaker);
            ++this.corners2;
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.shotsOnTeam2;
                this.automatonState = state.goalB;
                this.duelsEvaluator.setLastScorer(this.team2.getDefender());
            } else {
                res = this.rand.runif();
                this.automatonState = res <= 0.5f ? state.possessionB : state.possessionA;
            }
        }
    }

    private void handleShootingAction(int teamNumber) {
        if (teamNumber == 1) {
            Player goalkeeper;
            ++this.teamAIterations;
            Player shooter = this.team1.getShooter();
            float res = this.duelsEvaluator.tryShooting(shooter, goalkeeper = this.team2.getGoalkeeper());
            if (res == DuelsEvaluator.successfulEvent) {
                System.out.println("GOAL for " + this.team1.getTeamName() + " scored by: " + shooter.getFullPlayerName());
                this.duelsEvaluator.setLastScorer(shooter);
                this.automatonState = state.goalA;
                ++this.shotsOnTeam1;
            } else {
                ++this.teamBIterations;
                ++this.shotsOffTeam1;
                res = this.rand.runif();
                this.automatonState = res <= 0.4f ? state.cornerA : (res <= 0.8f ? state.possessionB : state.possessionA);
            }
        } else {
            Player goalkeeper;
            ++this.teamBIterations;
            Player shooter = this.team2.getShooter();
            float res = this.duelsEvaluator.tryShooting(shooter, goalkeeper = this.team1.getGoalkeeper());
            if (res == DuelsEvaluator.successfulEvent) {
                System.out.println("GOAL for " + this.team2.getTeamName() + " scored by: " + shooter.getFullPlayerName());
                this.duelsEvaluator.setLastScorer(shooter);
                this.automatonState = state.goalB;
                ++this.shotsOnTeam2;
            } else {
                ++this.shotsOffTeam2;
                res = this.rand.runif();
                this.automatonState = res <= 0.4f ? state.cornerB : (res <= 0.8f ? state.possessionA : state.possessionB);
            }
        }
    }

    private void updateScorers(TextArea ta_scorers, Player lastKnownScorer) {
        Platform.runLater(() -> ta_scorers.appendText(this.gameMinutes + "'\t" + lastKnownScorer.getFullPlayerName() + "\n"));
    }

    private void handleGoalAction(int teamNumber) {
        if (teamNumber == 1) {
            ++this.teamAIterations;
            ++this.goalsTeam1;
            this.automatonState = state.possessionB;
            System.out.println("GOAL A");
        } else {
            ++this.teamBIterations;
            ++this.goalsTeam2;
            this.automatonState = state.possessionA;
            System.out.println("GOAL B");
        }
        this.updateScorers(this.ta_scorers, this.duelsEvaluator.getLastKnownScorer());
    }

    private void handlePassingAction(int teamNumber) {
        if (teamNumber == 1) {
            ++this.teamAIterations;
            Player passer = this.team1.getPasser();
            Player intercepter = this.team2.getInterceptor();
            float res = this.duelsEvaluator.tryPassing(passer, intercepter);
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.attPassesTeam1;
                ++this.succPassesTeam1;
            } else {
                if (this.rand.runif() <= this.probabilityInterception) {
                    ++this.interceptTeam2;
                } else {
                    this.automatonState = this.rand.runif() <= 0.5f ? state.possessionA : state.possessionB;
                }
                ++this.attPassesTeam1;
            }
        } else {
            ++this.teamBIterations;
            Player passer = this.team2.getPasser();
            Player intercepter = this.team1.getInterceptor();
            float res = this.duelsEvaluator.tryPassing(passer, intercepter);
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.attPassesTeam2;
                ++this.succPassesTeam2;
            } else {
                if (this.rand.runif() <= this.probabilityInterception) {
                    ++this.interceptTeam1;
                } else {
                    this.automatonState = this.rand.runif() <= 0.5f ? state.possessionB : state.possessionA;
                }
                ++this.attPassesTeam2;
            }
        }
    }

    private void handleDribbleAction(int teamNumber) {
        if (teamNumber == 1) {
            ++this.teamAIterations;
            Player dribbler = this.team1.getDribbler();
            float res = this.rand.runif();
            Player opposition = res <= 0.5f ? this.team2.getMidfielder() : this.team2.getDefender();
            res = this.duelsEvaluator.tryDribbling(dribbler, opposition);
            ++this.attemptedDribbles1;
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.successfulDribbles1;
                this.automatonState = state.possessionA;
            } else if (this.rand.runif() <= this.probabilityFoul) {
                ++this.foulsTeam2;
                this.automatonState = state.possessionA;
            } else if (this.rand.runif() <= this.probabilityCorner) {
                this.automatonState = state.cornerA;
                ++this.corners1;
            } else {
                this.automatonState = state.possessionB;
                ++this.tacklesTeam2;
            }
        } else {
            float res;
            Player opposition;
            ++this.teamBIterations;
            Player dribbler = this.team2.getDribbler();
            res = this.duelsEvaluator.tryDribbling(dribbler, opposition = (res = this.rand.runif()) <= 0.5f ? this.team1.getMidfielder() : this.team1.getDefender());
            if (res == DuelsEvaluator.successfulEvent) {
                ++this.attemptedDribbles2;
                ++this.successfulDribbles2;
                this.automatonState = state.possessionB;
            } else {
                ++this.attemptedDribbles2;
                this.automatonState = state.possessionA;
                ++this.tacklesTeam1;
            }
            if (this.rand.runif() <= this.probabilityFoul) {
                ++this.foulsTeam1;
                this.automatonState = state.possessionB;
            } else if (this.rand.runif() <= this.probabilityCorner) {
                this.automatonState = state.cornerB;
                ++this.corners2;
            } else {
                this.automatonState = state.possessionA;
                ++this.tacklesTeam1;
            }
        }
    }

    private state handlePossessionState(state automatonState) {
        float probabilityToPass = 0.7f;
        float probabilityToDribble = 0.2f;
        float probabilityToShot = 0.1f;
        float bacon = this.rand.runif();
        automatonState = bacon <= probabilityToPass ? (automatonState == state.possessionA ? state.passA : state.passB) : (bacon <= probabilityToPass + probabilityToDribble ? (automatonState == state.possessionA ? state.dribbleA : state.dribbleB) : (automatonState == state.possessionA ? state.shootA : state.shootB));
        return automatonState;
    }

    public void nextMinute() {
        ++this.gameMinutes;
    }

    public void initLabels(Label lb_goals_team1, Label lb_goals_team2, Label lb_poss_team1, Label lb_poss_team2, Label lb_shots_off_target_team1, Label lb_shots_off_target_team2, Label lb_shots_on_target_team1, Label lb_shots_on_target_team2, Label lb_attempted_passes_team1, Label lb_attempted_passes_team2, Label lb_successful_passes_team1, Label lb_successful_passes_team2, Label lb_tackles_team1, Label lb_tackles_team2, Label lb_fouls_team1, Label lb_fouls_team2, Label lb_interceptions_team1, Label lb_interceptions_team2, Label lb_minute, Label lb_corners_team1, Label lb_corners_team2) {
        Platform.runLater(() -> {
            this.lb_goals_team1 = lb_goals_team1;
            this.lb_poss_team1 = lb_poss_team1;
            this.lb_shots_off_target_team1 = lb_shots_off_target_team1;
            this.lb_shots_on_target_team1 = lb_shots_on_target_team1;
            this.lb_attempted_passes_team1 = lb_attempted_passes_team1;
            this.lb_successful_passes_team1 = lb_successful_passes_team1;
            this.lb_tackles_team1 = lb_tackles_team1;
            this.lb_fouls_team1 = lb_fouls_team1;
            this.lb_interceptions_team1 = lb_interceptions_team1;
            this.lb_minute = lb_minute;
            this.lb_goals_team2 = lb_goals_team2;
            this.lb_poss_team2 = lb_poss_team2;
            this.lb_shots_off_target_team2 = lb_shots_off_target_team2;
            this.lb_shots_on_target_team2 = lb_shots_on_target_team2;
            this.lb_attempted_passes_team2 = lb_attempted_passes_team2;
            this.lb_successful_passes_team2 = lb_successful_passes_team2;
            this.lb_tackles_team2 = lb_tackles_team2;
            this.lb_fouls_team2 = lb_fouls_team2;
            this.lb_interceptions_team2 = lb_interceptions_team2;
            this.lb_minute = lb_minute;
            this.lb_corners_team1 = lb_corners_team1;
            this.lb_corners_team2 = lb_corners_team2;
        });
    }

    static enum state {
        initialState,
        halfTimeState,
        finalState,
        dribbleA,
        possessionA,
        cornerA,
        passA,
        shootA,
        goalA,
        goalKickA,
        dribbleB,
        possessionB,
        cornerB,
        passB,
        shootB,
        goalB,
        goalKickB;

    }
}

