/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javafx.scene.image.Image;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class Player
extends Thread {
    private String playerName;
    private String playerSurname;
    private Date dateOfBirth;
    private HashMap<String, Integer> stats;
    private String position;
    private Image playerImage;
    private Integer playerAge;

    public Player(ResultSet s) {
        try {
            this.playerName = s.getString("name");
            this.playerSurname = s.getString("surname");
            this.position = s.getString("position");
            this.dateOfBirth = s.getDate("date_of_birth");
            DateTime now = new DateTime();
            DateTime birhaday = new DateTime(this.dateOfBirth);
            Period period = new Period((ReadableInstant)birhaday, (ReadableInstant)now);
            this.playerAge = period.getYears();
            this.stats = new HashMap();
            for (int i = 8; i <= 23; ++i) {
                this.stats.put(s.getMetaData().getColumnName(i), s.getInt(i));
            }
        }
        catch (SQLException e) {
            System.out.println("Pravljenje objekta player EXP!");
        }
    }

    @Override
    public void run() {
        super.run();
    }

    public Integer getPlayerStats(String s) {
        return this.stats.get(s);
    }

    public HashMap<String, Integer> getStats() {
        return this.stats;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getPlayerSurname() {
        return this.playerSurname;
    }

    public String getFullPlayerName() {
        return this.playerName + " " + this.playerSurname;
    }

    public void setPlayerSurname(String playerSurname) {
        this.playerSurname = playerSurname;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getPosition() {
        return this.position;
    }

    public Image getPlayerImage() {
        return this.playerImage;
    }

    public int getPlayerAge() {
        return this.playerAge;
    }

    @Override
    public String toString() {
        String msg = this.playerName + " " + this.playerSurname + " " + this.getPosition() + " " + this.getPlayerAge() + "\n";
        return msg;
    }
}

