/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javafx.scene.image.Image;
import model.Player;
import model.RandomUtil;

public class Team {
    private String teamName;
    private String league_name;
    private int team_id;
    private int league_id;
    private Image team_logo;
    private Vector<Player> players;

    public Team() {
    }

    public Team(String teamName, int team_id, int league_id, String league_name, Vector<Player> players) {
        this.players = players;
        this.teamName = teamName;
        this.team_id = team_id;
        this.league_id = league_id;
        this.league_name = league_name;
    }

    public void setTeam_logo(Image team_logo) {
        this.team_logo = team_logo;
    }

    public Team(String teamName, int team_id, Image team_logo, int league_id, String league_name) {
        this.teamName = teamName;
        this.team_id = team_id;
        this.team_logo = team_logo;
        this.league_id = league_id;
        this.league_name = league_name;
    }

    public void sortPlayersByPosition() {
        HashMap<String, Integer> valuators = new HashMap<String, Integer>();
        valuators.put("gk", 0);
        valuators.put("lb", 1);
        valuators.put("cb", 2);
        valuators.put("rb", 3);
        valuators.put("dm", 4);
        valuators.put("cm", 5);
        valuators.put("am", 6);
        valuators.put("lw", 7);
        valuators.put("rw", 8);
        valuators.put("st", 9);
        Collections.sort(this.players, (o1, o2) -> (Integer)valuators.get(o1.getPosition()) - (Integer)valuators.get(o2.getPosition()));
    }

    public String getLeague_name() {
        return this.league_name;
    }

    public int getTeam_id() {
        return this.team_id;
    }

    public int getLeague_id() {
        return this.league_id;
    }

    public Image getTeam_logo() {
        return this.team_logo;
    }

    public void setPlayers(Vector players) {
        this.players = players;
    }

    public Vector<Player> getPlayers() {
        return this.players;
    }

    public Player getDribbler() {
        Vector<Player> homies = new Vector<Player>(this.players);
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("dribbling") - o1.getStats().get("dribbling"));
        RandomUtil rand = new RandomUtil();
        float val = rand.runif();
        if (val <= 0.7f) {
            val = rand.runif();
            if (val <= 0.5f) {
                return homies.get(0);
            }
            return homies.get(1);
        }
        val = rand.runif();
        if (val <= 0.5f) {
            return homies.get(rand.getFromInterval(2, 3));
        }
        return homies.get(rand.getFromInterval(4, 10));
    }

    public Player getTackler() {
        Vector<Player> homies = new Vector<Player>(this.players);
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("ball_winning") - o1.getStats().get("ball_winning"));
        RandomUtil rand = new RandomUtil();
        float val = rand.runif();
        if (val <= 0.73f) {
            val = rand.runif();
            if (val <= 0.55f) {
                return homies.get(0);
            }
            return homies.get(1);
        }
        val = rand.runif();
        if (val <= 0.5f) {
            return homies.get(rand.getFromInterval(2, 3));
        }
        return homies.get(rand.getFromInterval(4, 10));
    }

    public Player getShooter() {
        Vector<Player> homies = new Vector<Player>(this.players);
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("attacking_prowess") + o2.getStats().get("finishing") + o2.getStats().get("kicking_power") - (o1.getStats().get("attacking_prowess") + o1.getStats().get("finishing") + o1.getStats().get("kicking_power")));
        RandomUtil rand = new RandomUtil();
        float val = rand.runif();
        if (val <= 0.6f) {
            val = rand.runif();
            if (val <= 0.55f) {
                return homies.get(0);
            }
            return homies.get(1);
        }
        val = rand.runif();
        if (val <= 0.7f) {
            return homies.get(rand.getFromInterval(2, 3));
        }
        return homies.get(rand.getFromInterval(4, 10));
    }

    public Player getMidfielder() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("am") && !homie.getPosition().equals("cm") && !homie.getPosition().equals("dm")) continue;
            homies.add(homie);
        }
        int randomPlayer = new RandomUtil().getFromInterval(0, homies.size() - 1);
        return (Player)homies.get(randomPlayer);
    }

    public Player getWinger() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("lw") && !homie.getPosition().equals("rw")) continue;
            homies.add(homie);
        }
        int randomPlayer = new RandomUtil().getFromInterval(0, homies.size() - 1);
        return (Player)homies.get(randomPlayer);
    }

    public Player getDefender() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("cb") && !homie.getPosition().equals("lb") && !homie.getPosition().equals("rb")) continue;
            homies.add(homie);
        }
        int randomPlayer = new RandomUtil().getFromInterval(0, homies.size() - 1);
        return (Player)homies.get(randomPlayer);
    }

    public Player getStriker() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("st")) continue;
            homies.add(homie);
        }
        int randomPlayer = new RandomUtil().getFromInterval(0, homies.size() - 1);
        return (Player)homies.get(randomPlayer);
    }

    public Player getGoalkeeper() {
        Player goalkeeper = null;
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("gk")) continue;
            goalkeeper = homie;
            break;
        }
        return goalkeeper;
    }

    public Player getSetPieceTaker() {
        Vector<Player> homies = new Vector<Player>(this.players);
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("place_kicking") - o1.getStats().get("place_kicking"));
        RandomUtil rand = new RandomUtil();
        float val = rand.runif();
        if (val <= 0.8f) {
            return homies.get(0);
        }
        return homies.get(1);
    }

    public String getTeamName() {
        return this.teamName;
    }

    public Player getBestPasser() {
        Vector<Player> homies = new Vector<Player>(this.players);
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("low_pass") + o2.getStats().get("lofted_pass") - (o1.getStats().get("low_pass") + o1.getStats().get("lofted_pass")));
        return homies.get(0);
    }

    public Player getPasser() {
        float probMidfield = 0.4f;
        float probDefense = 0.3f;
        float probWings = 0.2f;
        float probStrikers = 0.1f;
        RandomUtil rand = new RandomUtil();
        float dragon = rand.runif();
        Vector<Player> homies = dragon <= probMidfield ? this.getMidfilders() : (dragon <= probMidfield + probDefense ? this.getDefenders() : (dragon <= probMidfield + probDefense + probWings ? this.getWingers() : this.getStrikers()));
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("low_pass") + o2.getStats().get("lofted_pass") - (o1.getStats().get("low_pass") + o1.getStats().get("lofted_pass")));
        dragon = rand.runif();
        if (dragon <= 0.6f) {
            return homies.get(0);
        }
        if (homies.size() == 1) {
            return homies.get(0);
        }
        return homies.get(rand.getFromInterval(1, homies.size() - 1));
    }

    public Vector<Player> getWingers() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("lw") && !homie.getPosition().equals("rw")) continue;
            homies.add(homie);
        }
        return homies;
    }

    public Vector<Player> getDefenders() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("cb") && !homie.getPosition().equals("rb") && !homie.getPosition().equals("lb")) continue;
            homies.add(homie);
        }
        return homies;
    }

    public Vector<Player> getMidfilders() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("dm") && !homie.getPosition().equals("cm") && !homie.getPosition().equals("am")) continue;
            homies.add(homie);
        }
        return homies;
    }

    public Vector<Player> getStrikers() {
        Vector<Player> homies = new Vector<Player>();
        for (Player homie : this.players) {
            if (!homie.getPosition().equals("st")) continue;
            homies.add(homie);
        }
        return homies;
    }

    public Player getInterceptor() {
        float probMidfield = 0.4f;
        float probDefense = 0.35f;
        float probWings = 0.15f;
        float probStrikers = 0.05f;
        RandomUtil rand = new RandomUtil();
        float dragon = rand.runif();
        Vector<Player> homies = dragon <= probMidfield ? this.getMidfilders() : (dragon <= probMidfield + probDefense ? this.getDefenders() : (dragon <= probMidfield + probDefense + probWings ? this.getWingers() : this.getStrikers()));
        Collections.sort(homies, (o1, o2) -> o2.getStats().get("defensive_prowess") + o2.getStats().get("ball_winning") - (o1.getStats().get("defensive_prowess") + o1.getStats().get("ball_winning")));
        dragon = rand.runif();
        if (dragon <= 0.6f) {
            return homies.get(0);
        }
        if (homies.size() == 1) {
            return homies.get(0);
        }
        return homies.get(rand.getFromInterval(1, homies.size() - 1));
    }
}

