-- HTTP requests
local http_request = {}
http_request["/"] = "index.html"
http_request["/color_wheel.png"] = "color_wheel.png"

-- HTTP content-types
local get_content_type = {}
get_content_type["/"] = "text/html"
get_content_type["/color_wheel.png"] = "image"

function set_led_values(red, green, blue)
    pwm.setduty(7, red)
    pwm.setduty(6, green)
    pwm.setduty(5, blue)
end

-- Enable the rainbow color effect
function enable_rainbow()
    local red = 1023
    local green = 0
    local blue = 0
    local level = 0
    local amount = 10

    set_led_values(1023, 0, 0)

    tmr.alarm(2, 80, 1, function()
        
        -- Rainbow algorithm:
            -- initial values: (MAX, 0, 0) -->> [RED, GREEN, BLUE]      -> level = INITIAL
            -- red stays at MAX while green goes up to MAX              -> level = 0
            -- green stays at MAX while red goes down to MIN            -> level = 1
            -- green still stays at MAX while blue goes up to MAX       -> level = 2
            -- blue stays at MAX while green goes down to MIN           -> level = 3
            -- blue stays at MAX while red goes up to MAX               -> level = 4
            -- red stays at MAX while blue goes down to MIN             -> level = 5

        if (level == 0) then
            green = green + amount
            pwm.setduty(6, green)
            if (green >= 1000) then
                level = 1
            end
        elseif (level == 1) then
            red = red - amount
            pwm.setduty(7, red)
            if (red <= 20) then
                level = 2
            end
        elseif (level == 2) then
            blue = blue + amount
            pwm.setduty(5, blue)
            if (blue >= 1000) then
                level = 3
            end
        elseif (level == 3) then
            green = green - amount
            pwm.setduty(6, green)
            if (green <= 20) then
                level = 4
            end
        elseif (level == 4) then
            red = red + amount
            pwm.setduty(7, red)
            if (red >= 1000) then
                level = 5
            end
        elseif (level == 5) then
            blue = blue - amount
            pwm.setduty(5, blue)
            if (blue <= 20) then
                level = 0
            end
        end

    end)
end

-------------------------------------------------------------
--====================== STARTUP ============================
-------------------------------------------------------------
wifi.setmode(wifi.STATION)

-- Setting username and password of the access point
if file.open("password.txt", r) then
   local username = file.readline()
    local password = file.readline()
    file.close()

    username = string.sub(username, 1, #username-1)
    password = string.sub(password, 1, #password-1)

    wifi.sta.config(username, password)
    
else
    print("[ERROR] Can't open: password.txt")
end

-- PWM settings
pwm.setup(5, 500, 1023)
pwm.setup(6, 500, 1023)
pwm.setup(7, 500, 1023)

pwm.start(5)
pwm.start(6)
pwm.start(7)
-------------------------------------------------------------
--===========================================================
-------------------------------------------------------------

-- The position of the last byte
local file_position = 0
-- Blink indicator
local blink_active = false
-- Rainbow indicator
local rainbow_active = false

-- Connection with the access point
tmr.alarm(1, 1000, 1, function() 
    if wifi.sta.getip() == nil then
        print("Getting IP address...") 
    else 
        tmr.stop(1)
        print("IP address: "..wifi.sta.getip())
    end 
end)

if srv then 
    srv:close() 
    srv=nil 
end

-- Create a TCP server
srv=net.createServer(net.TCP)

-- Listen on the port 80
srv:listen(80, function(conn)

    -- The event "receive" has happend...
    conn:on("receive", function(conn,request)
        
        print("-- New request --")

        --========== AJAX request ============
        if (string.find(request, "COL_VALs")) then

            if (blink_active == true) then
                tmr.stop(4)
                blink_active = false
            end

            local _, _, red_value, green_value, blue_value = string.find(request, "COL_VALs[*]([0-9]+)[*]([0-9]+)[*]([0-9]+)")

            print ("Red: "..red_value)
            print ("Green: "..green_value)
            print ("Blue: "..blue_value)

            set_led_values(red_value, green_value, blue_value)

            -- "sent" event trigger
            conn:send("OK")
        
        --========== AJAX request ============
        elseif (string.find(request, "RAINBOW_BUTTON")) then

            if (blink_active == true) then
                tmr.stop(4)
                blink_active = false
            end

            local _, _, rainbow_value = string.find(request, "RAINBOW_BUTTON[*]([A-Z]+)")

            if (rainbow_value == "ON") then
                rainbow_active = true
                print ("Rainbow: ON.")
                enable_rainbow()
            elseif (rainbow_value == "OFF") then
                rainbow_active = false
                print ("Rainbow: OFF.")
                tmr.stop(2)
                pwm.setduty(7, 1023)
                pwm.setduty(6, 0)
                pwm.setduty(5, 0)
            end

            -- "sent" event trigger
            conn:send("OK")

        --========== AJAX request ============
        elseif (string.find(request, "BLINK")) then
            local _, _, blink_time = string.find(request, "BLINK[*]([0-9]+)")
            local blink_state = true
            blink_active = true

            if (blink_active == true) then
                tmr.stop(4)
            end

            print ("Blink time: "..blink_time)

            local red_value_temp = pwm.getduty(7)
            local green_value_temp = pwm.getduty(6)
            local blue_value_temp = pwm.getduty(5)

            tmr.alarm(4, blink_time, 1, function()

                if (blink_state == true) then
                    set_led_values(0, 0, 0)
                    blink_state = false
                elseif (blink_state == false) then
                    set_led_values(red_value_temp, green_value_temp, blue_value_temp)
                    blink_state = true
                end

            end)

            -- "sent" event trigger
            conn:send("OK")

        else    
            --========== File request ============

            if (blink_active == true) then
                tmr.stop(4)
                blink_active = false
            end

            if (rainbow_active == true) then
                tmr.stop(2)
                rainbow_active = false
            end

            local _, _, path = string.find(request, "GET ([A-Za-z+/_.]+) HTTP")

            if get_content_type[path] then
                requestFile = http_request[path]
                print("Sending file "..requestFile)          
                file_position = 0

                -- "sent" event trigger
                conn:send("HTTP/1.1 200 OK\r\nContent-Type: "..get_content_type[path].."\r\n\r\n")         
            else
                print("[Error] File "..path.." not found!")
                conn:send("HTTP/1.1 404 Not Found\r\n\r\n")
                conn:close()
            end
        end

        collectgarbage()

    end)

    conn:on("sent", function(conn)

        -- The event "sent" has happened
        if requestFile then
            if file.open (requestFile, r) then
                file.seek ("set", file_position)
                -- Max. chunk size is 1460 bytes
                local chunk = file.read(1400)
                file.close()

                if chunk then
                    file_position = file_position + #chunk
                    print(file_position.." bytes were sent.")
                    conn:send(chunk)
                    if (string.len (chunk) == 1400) then
                        return
                    end
                end
            else
                print("[ERROR] Can't open: "..requestFile)
            end
        end
        
        conn:close()
        print("Connection closed.")

        collectgarbage()
    end)
end)
