/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.app;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.internal.widget.ViewUtils;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatMultiAutoCompleteTextView;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.AppCompatRatingBar;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.View;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class AppCompatViewInflater {
    static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final Map<String, Constructor<? extends View>> sConstructorMap = new HashMap<String, Constructor<? extends View>>();
    private final Context mContext;
    private final Object[] mConstructorArgs = new Object[2];

    public AppCompatViewInflater(Context context) {
        this.mContext = context;
    }

    public final View createView(View parent, String name, @NonNull Context context, @NonNull AttributeSet attrs, boolean inheritContext, boolean themeContext) {
        Context originalContext = context;
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        if (themeContext) {
            context = ViewUtils.themifyContext(context, attrs, true, true);
        }
        switch (name) {
            case "EditText": {
                return new AppCompatEditText(context, attrs);
            }
            case "Spinner": {
                return new AppCompatSpinner(context, attrs);
            }
            case "CheckBox": {
                return new AppCompatCheckBox(context, attrs);
            }
            case "RadioButton": {
                return new AppCompatRadioButton(context, attrs);
            }
            case "CheckedTextView": {
                return new AppCompatCheckedTextView(context, attrs);
            }
            case "AutoCompleteTextView": {
                return new AppCompatAutoCompleteTextView(context, attrs);
            }
            case "MultiAutoCompleteTextView": {
                return new AppCompatMultiAutoCompleteTextView(context, attrs);
            }
            case "RatingBar": {
                return new AppCompatRatingBar(context, attrs);
            }
            case "Button": {
                return new AppCompatButton(context, attrs);
            }
            case "TextView": {
                return new AppCompatTextView(context, attrs);
            }
        }
        if (originalContext != context) {
            return this.createViewFromTag(context, name, attrs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            this.mConstructorArgs[0] = context;
            this.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                View view = this.createView(name, "android.widget.");
                return view;
            }
            View view = this.createView(name, null);
            return view;
        }
        catch (Exception e) {
            View view = null;
            return view;
        }
        finally {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
        }
    }

    private View createView(String name, String prefix) throws ClassNotFoundException, InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<View> clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(this.mConstructorArgs);
        }
        catch (Exception e) {
            return null;
        }
    }
}

