package com.pavle.patternswitch.activities;


import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.pavle.patternswitch.R;
import com.pavle.patternswitch.db.DBOperator;
import com.pavle.patternswitch.global.Global;
import com.pavle.patternswitch.objects.Pattern;
import com.pavle.patternswitch.objects.Trigger;

public class CreateActivity extends Activity implements View.OnClickListener {

    private Context mContext;
    private EditText etName;
    private EditText etDescription;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_create);

        mContext = this;

        etName = (EditText) findViewById(R.id.etCreateActivityName);
        etDescription = (EditText) findViewById(R.id.etCreateActivityDescription);
        Button b = (Button)findViewById(R.id.btnCreateActivityNew);
        Button b1 = (Button)findViewById(R.id.btnCreateActivityFinish);
        b.setOnClickListener(this);
        b1.setOnClickListener(this);

        setInterface();
    }

    private void setInterface() {
        Pattern p = Global.getPattern();
        if(p!=null){
            etName.setText(p.getName());
            etDescription.setText(p.getDescription());
            if(p.getTriggerList().size() > 0){
                TextView tvTriggers = (TextView) findViewById(R.id.tvCreateActivity);
                tvTriggers.setText("");
                for(Trigger t:p.getTriggerList()){
                    tvTriggers.append(t.toString());
                }
            }
        }
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()){
            case R.id.btnCreateActivityNew:
                ceateNewTrigger();
                break;
            case R.id.btnCreateActivityFinish:
                if(Global.getPattern()!=null) {
                    if (Global.getPattern().getTriggerList().size() > 0) {
                        savePatternToMemory();
                    }
                }
        }
    }

    private void savePatternToMemory() {
        DBOperator dbOp = new DBOperator(this);
        dbOp.execute(Global.getPattern());
    }


    private void ceateNewTrigger() {
        if(etName.getText().toString().length() > 0 && etDescription.getText().toString().length() > 0) {
            Pattern global = Global.getPattern();
            if(global==null){
                Global.setPattern(new Pattern(etDescription.getText().toString(),etName.getText().toString()));
            }
            Intent i = new Intent(CreateActivity.this,CreatePatternActivity.class);
            startActivity(i);
            this.finish();
        }
        else{
            Toast.makeText(mContext,"You need to enter text in both fields",Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onBackPressed() {
        Global.setPattern(null);
        Global.setTriggerDevelopment(null);
        Global.setDeviceList(null);

        Intent i = new Intent(CreateActivity.this,PatternPreviewActivity.class);
        startActivity(i);
        this.finish();
    }

    public void onSavingDone(){
        Global.setPattern(null);
        Global.setTriggerDevelopment(null);
        Global.setDeviceList(null);
        Intent i = new Intent(CreateActivity.this, PatternPreviewActivity.class);
        startActivity(i);
        this.finish();
    }
}
