package com.pavle.patternswitch.adapter;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.pavle.patternswitch.R;
import com.pavle.patternswitch.objects.Device;
import com.pavle.patternswitch.objects.Pattern;
import com.pavle.patternswitch.objects.Trigger;

import java.util.ArrayList;
import java.util.List;


public class DeviceAdapter extends ArrayAdapter<Device>
{
    private ArrayList<Device> mList;
    private Context mContext;

    /*
     * Creates the Adapter for the list
     */
    public DeviceAdapter(Context context, int layoutId, ArrayList<Device> list)
    {
    	super(context,layoutId,list);
        mList = list;
        mContext = context;

    }
    /**
     * inflate view for each row
     */
    @SuppressLint("InflateParams")
	@Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        Device current = mList.get(position);
        /* if the given channel row view is not being updated*/
        if (v == null) {
            /* inflate layout */
            LayoutInflater vi = LayoutInflater.from(getContext());
            v = vi.inflate(R.layout.list_item_device, null, false);
        }
        
        /*get the component pointers */
        TextView tvDeviceName = (TextView) v.findViewById(R.id.tvDeviceName);
        TextView tvDeviceDistance = (TextView) v.findViewById(R.id.tvDeviceDistance);

        tvDeviceName.setText((current.getDevice().getName()));
        tvDeviceDistance.setText(String.valueOf(current.getRSSI()));

        return v;
    }

}