package com.pavle.patternswitch.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import com.pavle.patternswitch.R;
import com.pavle.patternswitch.objects.Device;
import com.pavle.patternswitch.objects.Interaction;

import java.util.ArrayList;


public class InteractionAdapter extends ArrayAdapter<Interaction>
{
    private ArrayList<Interaction> mList;
    private Context mContext;

    /*
     * Creates the Adapter for the list
     */
    public InteractionAdapter(Context context, int layoutId, ArrayList<Interaction> list)
    {
    	super(context,layoutId,list);
        mList = list;
        mContext = context;

    }
    /**
     * inflate view for each row
     */
	@Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        final Interaction current = mList.get(position);
        /* if the given channel row view is not being updated*/
        if (v == null) {
            /* inflate layout */
            LayoutInflater vi = LayoutInflater.from(getContext());
            v = vi.inflate(R.layout.list_item_interaction, parent, false);
        }
        
        /*get the component pointers */
        TextView tvInteractionDeviceName = (TextView) v.findViewById(R.id.tvDeviceNameInteraction);
        TextView tvInteractionDeviceDistance = (TextView) v.findViewById(R.id.tvDeviceDistanceInteraction);


        RadioButton rbOn = (RadioButton) v.findViewById(R.id.rbTurnOn);
        rbOn.setChecked(true);

        Device d = current.getDevice();//Gets Device object and then BluettothDevice object

        tvInteractionDeviceName.setText(current.getDeviceName());
        tvInteractionDeviceDistance.setText(String.valueOf(d.getRSSI()));

        RadioGroup rg = (RadioGroup) v.findViewById(R.id.rgInteraction);
        rg.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                switch (checkedId) {
                    case R.id.rbTurnOn:
                        current.setMethodFlags(Interaction.FLAG_ON);
                        break;
                    case R.id.rbTurnOff:
                        current.setMethodFlags(Interaction.FLAG_OFF);
                        break;
                }
            }
        });

        final CheckBox cbInteraction =  (CheckBox) v.findViewById(R.id.cbInteraction);
        cbInteraction.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                current.setChecked(isChecked);
            }
        });

        return v;
    }

}