package com.pavle.patternswitch.adapter;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.pavle.patternswitch.R;
import com.pavle.patternswitch.activities.PatternPreviewActivity;
import com.pavle.patternswitch.objects.Device;
import com.pavle.patternswitch.objects.Pattern;
import com.pavle.patternswitch.objects.Trigger;

import java.util.ArrayList;
import java.util.List;


public class PatternAdapter extends ArrayAdapter<Pattern>
{
    //List of colors
    private ArrayList<Pattern> mList;
    private Context mContext;

    /*
     * Creates the Adapter for the list
     */
    public PatternAdapter(Context context, int layoutId, ArrayList<Pattern> list)
    {
    	super(context,layoutId,list);
        mList = list;
        mContext = context;

    }
    /**
     * inflate view for each row
     */
    @SuppressLint("InflateParams")
	@Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View v = convertView;
        final Pattern current = mList.get(position);
        /* if the given channel row view is not being updated*/
        if (v == null) {
            /* inflate layout */
            LayoutInflater vi = LayoutInflater.from(getContext());
            v = vi.inflate(R.layout.list_item, null, false);
        }
        
        /*get the component pointers */
        TextView tvPatternName = (TextView) v.findViewById(R.id.tvPreviewPatternName);
        TextView tvPatternDescription = (TextView) v.findViewById(R.id.tvPreviewPatternDescription);

        tvPatternName.setText(current.getName());
        tvPatternDescription.setText(current.getDescription());

        Switch tbPattern = (Switch) v.findViewById(R.id.tbPreviewPattern);
        tbPattern.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                PatternPreviewActivity a = (PatternPreviewActivity)mContext;
                if(isChecked){
                    a.startMonitoringPattern(current);
                }
                else{
                    a.stopMonitoringPattern(current);
                }
            }
        });


        return v;
    }

}