package com.pavle.patternswitch.objects;

import java.util.UUID;

/**
 * Contains all methods that need to be done on a device.
 * Retrieves set of FLAGS that indicate which methods should be called
 * On that particular device.
 */
public class Interaction {
    private Device mDevice;
    private int mMethodFlags;
    private boolean mChecked;
    private UUID triggerUUID;
    private String mDeviceName;

    public static final int FLAG_ON = 101;
    public static final int FLAG_OFF = 102;


    public Interaction(Device device,int MethodFlags){
        mMethodFlags = MethodFlags;
        setDevice(device);
    }
    public Interaction(Device device){
        mDeviceName = device.getDevice().getName();
        mDevice = device;
    }

    public Device getDevice() {
        return mDevice;
    }
    public int getMethodFlags(){
        return  mMethodFlags;
    }

    public void setMethodFlags(int methodFlags){
        mMethodFlags = methodFlags;
    }

    public void setChecked(boolean check){
        mChecked = check;
    }
    public boolean isChecked(){
        return mChecked;
    }

    public UUID getTriggerUUID() {
        return triggerUUID;
    }

    public void setTriggerUUID(UUID triggerUUID) {
        this.triggerUUID = triggerUUID;
    }

    public String getDeviceName() {
        return mDeviceName;
    }

    public void setDeviceName(String deviceName) {
        mDeviceName = deviceName;
    }

    public void setDevice(Device device) {
        if(device!=null){
            mDevice = device;
            setDeviceName(device.getDevice().getName());
        }
    }
}
