package com.pavle.patternswitch.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Contains list of Triggers and List of Devices.
 *  along with the description of the pattern, and pattern name
 */
public class Pattern {
    private List<Trigger> mTriggerList;
    private List<Device> mDeviceList;
    private String mDescription;
    private String mName;
    private UUID mUUID;
    private boolean mChecked;

    public Pattern(List<Trigger> list ){
        mUUID = UUID.randomUUID();
        mTriggerList = list;
    }
    public Pattern(String description, String name){
        mTriggerList = new ArrayList<>();
        mDescription = description;
        mName = name;
        mUUID = UUID.randomUUID();
    }

    public void setDeviceList(List<Device> listD) {
        mDeviceList = listD;

        /*Every time we set a device list, check to see if any interactions
        or triggers have that device name
         */
        for(Device d:listD){
            for(Trigger t:mTriggerList){
                if(t.getTriggerDeviceName().equals(d.getDevice().getName())){
                    t.setDevice(d);
                }
                for(Interaction i:t.getInteractionList()){
                    if(i.getDeviceName().equals(d.getDevice().getName())){
                        i.setDevice(d);
                    }
                }
            }
        }
    }

    public List<Trigger> getTriggerList() {
        return mTriggerList;
    }

    public List<Device> getDeviceList() {
        return mDeviceList;
    }

    public String getDescription() {
        return mDescription;
    }

    public void setDescription(String description) {
        mDescription = description;
    }

    public String getName() {
        return mName;
    }

    public void setName(String name) {
        mName = name;
    }

    public void setTriggerList(List<Trigger> triggerList) {
        mTriggerList = triggerList;
    }

    public UUID getUUID() {
        return mUUID;
    }

    public void setUUID(UUID UUID) {
        mUUID = UUID;
    }

    public boolean isChecked() {
        return mChecked;
    }

    public void setChecked(boolean checked) {
        mChecked = checked;
    }
}
