package com.pavle.patternswitch.objects;

import java.util.List;
import java.util.UUID;

/**
 * Contains distance from the specific "Trigger" device, and when
 * that distance is satisfied then Interactions are called on the
 * avaliable devices.
 */
public class Trigger {
    private boolean isOn;
    private int mDistance;
    private List<Interaction> mInteractionList;
    private String mTriggerDeviceName;
    private int mGoingTo;
    private UUID mUUID;
    private UUID mPatternUUID;
    private Device mDevice;

    public static final int GOING_TO = 0;
    public static final int COMING_FROM = 1;


    public int getGoingTo() {
        return mGoingTo;
    }

    public void setGoingTo(int goingTo) {
        mGoingTo = goingTo;
    }

    public Trigger(){
        mUUID = UUID.randomUUID();
    }

    public Trigger(int distance, List<Interaction> interactions,String triggerDeviceName){
        this();
        mTriggerDeviceName = triggerDeviceName;
        mDistance = distance;
        mInteractionList = interactions;
    }

    public int getDistance() {
        return mDistance;
    }

    public void setDistance(int distance) {
        mDistance = distance;
    }

    public List<Interaction> getInteractionList() {
        return mInteractionList;
    }

    public void setInteractionList(List<Interaction> interactionList) {
        mInteractionList = interactionList;
    }

    public String getTriggerDeviceName() {
        return mTriggerDeviceName;
    }

    public void setTriggerDeviceName(String triggerDeviceName) {
        mTriggerDeviceName = triggerDeviceName;
    }

    @Override
    public String toString() {
        return "Trigger device name: "+mTriggerDeviceName+"    Number of interactions: "+mInteractionList.size()+"\n";
    }

    public UUID getUUID() {
        return mUUID;
    }

    public void setUUID(UUID UUID) {
        mUUID = UUID;
    }

    public UUID getPatternUUID() {
        return mPatternUUID;
    }

    public void setPatternUUID(UUID patternUUID) {
        mPatternUUID = patternUUID;
    }

    public Device getDevice() {
        return mDevice;
    }

    public void setDevice(Device device) {
        if(device!=null){
            mDevice = device;
            setTriggerDeviceName(device.getDevice().getName());
        }
    }

    public boolean isOn() {
        return isOn;
    }

    public void setIsOn(boolean isOn) {
        this.isOn = isOn;
    }
}
