package com.pavle.patternswitch.objects;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;

import com.pavle.patternswitch.bluetooth.BLeDefinedUUID;
import com.pavle.patternswitch.bluetooth.BleWrapper;
import com.pavle.patternswitch.bluetooth.BleWrapperCallbacks;
import com.pavle.patternswitch.bluetooth.BleWrapperProxy;

/**
 * Created by Pavle
 */
public class TriggerCallback implements BleWrapperCallbacks {

    private boolean mOn;
    private BleWrapper mWrapper;
    private Context mParent;
    private Trigger mTrigger;
    private BleWrapper mParentWrapper;
    private BleWrapperProxy mProxy;

    public void setOn(Boolean on,BleWrapper wrapper,Context a,Trigger t,BleWrapper parentWrapper,BleWrapperProxy proxy){
        mOn = on;
        mWrapper = wrapper;
        mParent = a;
        mTrigger = t;
        mParentWrapper = parentWrapper;
        mProxy = proxy;
    }


    @Override
    public void uiDeviceFound(BluetoothDevice device, int rssi, byte[] record) {

    }

    @Override
    public void uiDeviceConnected() {
    }

    @Override
    public void uiDeviceDisconnected() {

    }

    @Override
    public void uiAvailableServices(boolean success) {
                try {
                    String newValue;
                    if(mOn) {
                        newValue = "0x01";
                    }
                    else newValue = "0x00";
                    byte[] dataToWrite = mWrapper.parseHexStringToBytes(newValue);

                    boolean wellDone = mWrapper.writeDataToCharacteristic(BLeDefinedUUID.Service.mControlServiceUUID,
                            BLeDefinedUUID.Characteristic.mControlStateUUID, dataToWrite);

                    if(wellDone)
                        mTrigger.setIsOn(!mTrigger.isOn());

                }
                catch (Exception e){
                    e.printStackTrace();
                }
                finally {
                    mWrapper.disconnect();
                    mWrapper.close();
                }
    }

    @Override
    public void uiCharacteristicsForServices(boolean success) {

    }

    @Override
    public void uiNotificationsSet(boolean success) {

    }

    @Override
    public void uiNewRssiAvailable(BluetoothGatt gatt, BluetoothDevice device, int rssi) {

    }

    @Override
    public void uiNewValueForCharacteristic(BluetoothGatt gatt, BluetoothDevice device, BluetoothGattService service, BluetoothGattCharacteristic ch, String strValue, int intValue, byte[] rawValue, String timestamp) {

    }

    @Override
    public void uiGotNotification(BluetoothGatt gatt, BluetoothDevice device, BluetoothGattService service, BluetoothGattCharacteristic characteristic) {

    }

    @Override
    public void uiSuccessfulWrite(BluetoothGatt gatt, BluetoothDevice device, BluetoothGattService service, BluetoothGattCharacteristic ch, String description) {

    }

    @Override
    public void uiFailedWrite(BluetoothGatt gatt, BluetoothDevice device, BluetoothGattService service, BluetoothGattCharacteristic ch, String description) {

    }
}
