/*
 maliNiz[5, 10, 15, 20]
 velikiNiz[25, 50, 75, 100]
 trazeniBroj			random broj od 1 do 999
 nizJC[]			niz od 4 random broja od 1 do 9
 indeks			indeks iz maliNiz ili velikiNiz pri biranju brojeva
 operatori["+", "-", "/", "*"]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void racunaj(int trazeniBroj, int nizBrojeva[]);
void rezultat(int trazeniBroj, int noviNizBrojeva[], int k, int tb);
void pisi(int niz[], int indeksOdsecanja);

char op[10];
int indeksOdsecanja = 6;

int main() {
	
	int maliNiz[4] = {5, 10, 15, 20};
	int velikiNiz[4] = {25, 50, 75, 100};
	int i; //koristicu ga kao brojac u petlji i kao indeks
	int j = 0; // brojac konacnog niza brojeva
	int nizJC[4];
	int nizBrojeva[6];
	
	//generisanje i ispisivanje nasumicnog broja koji se trazi
	srand(time(NULL));
	int trazeniBroj = rand() % 999 + 1;
	printf("Izracunati broj:\t%d\n", trazeniBroj);
	
	//generisanje i ispisivanje niza jednocifrenih brojeva
	printf("Koristeci brojeve:\t");
	for(i = 0; i < 4; i++) {
		nizJC[i] = rand() % 9 + 1;
		nizBrojeva[j++] = nizJC[i];
		printf("%d ", nizJC[i]);
		fflush(stdout);
		sleep(1);
		srand(time(NULL));
	}
	
	//generisanje i ispisivanje poslednja dva broja
	i = rand() % 4;
	nizBrojeva[j++] = maliNiz[i];
	printf("%d ", maliNiz[i]);
	
	fflush(stdout);
	sleep(1);
	srand(time(NULL));
	
	i = rand() % 4;
	nizBrojeva[j++] = velikiNiz[i];
	printf("%d ", velikiNiz[i]);
	
	printf("\n");	
	
	//ispisivanje resenja
	printf("Resenje je:\t");
	racunaj(trazeniBroj, nizBrojeva);
	
	return 0;
}

void racunaj(int trazeniBroj, int nizBrojeva[]) {
	
	FILE *f;
	f = fopen("matrica.txt", "r");
	int indikator = 0;
	char c;
	int i;
	int indeksi[6];
	int noviNizBrojeva[6];
	
	while(indeksOdsecanja != 0) {
		
		while(c != EOF) {
		
			for(i = 0; i < indeksOdsecanja; i++) indeksi[i] = getc(f) - 48;
			c = getc(f);
		
			for(i = 0; i < indeksOdsecanja; i++) noviNizBrojeva[i] = nizBrojeva[indeksi[i]];
		
			rezultat(trazeniBroj, noviNizBrojeva, 0, noviNizBrojeva[0]);
		
			for(i = 0; i < indeksOdsecanja; i++) noviNizBrojeva[i] = 0;
		
		}
		printf("----------- korisceno je %d elemenata niza -----------\n\n", indeksOdsecanja);
		indeksOdsecanja--;
		rewind(f);
	}
	
	fclose(f);
	return;
}

void rezultat(int trazeniBroj, int noviNizBrojeva[], int k, int tb) {
  
  if(k == indeksOdsecanja-1){
    if (trazeniBroj == tb){
      pisi(noviNizBrojeva, indeksOdsecanja);
    }
  }
  else{
    op[k] = '+';
    rezultat(trazeniBroj, noviNizBrojeva, k+1, tb + noviNizBrojeva[k+1]);
    op[k] = '-';
    rezultat(trazeniBroj, noviNizBrojeva, k+1, tb - noviNizBrojeva[k+1]);
    op[k] = '*';
    rezultat(trazeniBroj, noviNizBrojeva, k+1, tb * noviNizBrojeva[k+1]);
    op[k] = '/';
    if(tb != 0 && (tb % noviNizBrojeva[k+1] == 0)) rezultat(trazeniBroj, noviNizBrojeva, k+1, tb / noviNizBrojeva[k+1]);
  }
}

void pisi(int niz[], int indeksOdsecanja){
 
	int i, stanjeSteka = 0;
	int preskoci = 0;
  
	for(i = 0; i < indeksOdsecanja; i++)
		if (op[i] == '/' || op[i] == '*') stanjeSteka++;
  
	for(i = 0; i < stanjeSteka; i++) printf("(");
	  
	for(i = 0; i < indeksOdsecanja; i++) {
		if (preskoci == 1) {
			preskoci = 0;
			continue;
		}
		printf("%d", niz[i]);
		if(op[i] == '/' || op[i] == '*') printf(")");
		if((op[i] == '/' || op[i] == '*') && niz[i+1] == 1) {
			preskoci = 1;
			continue;
		}
		if(niz[i+1]!=0) printf("%c", op[i]);
	}
  
  printf("\n"); 
}