; racunamo pozicije trazenog broja u listi
(defn pozicije [x lista]
  (keep-indexed (fn [i v] (if (= x v) i)) lista))
(println "pozicije 1 [1 2 3 1 1 59 0 1] =" (pozicije 1 [1 2 3 1 1 59 0 1]))

; qsort
(defn qsort [lista]
  (if (seq lista) 
    (concat 
      (qsort (filter (fn [x] (<= x (first lista))) (rest lista))) ; manji
      [(first lista)] ; glava liste kao vektor kako bismo mogli da radimo concat, ekvivalento pozivu (vec (first lista))
      (qsort (filter (fn [x] (> x (first lista))) (rest lista)))) ; veci
    []))
(println "qsort (shuffle (range 1 100)) =" (qsort (shuffle (range 1 100))))

; brisanje ponavljanja (ugradjena funkcija: dedupe)
(defn brisiPonavljanja [lista]
  (if (seq lista)
    (concat
      [(first lista)]
      (brisiPonavljanja (drop-while (partial = (first lista)) (rest lista))))
    []))
(println "brisiPonavljanja [1 1 1 1 2 2 2 22 3 4 4 4] =" (brisiPonavljanja [1 1 1 1 2 2 2 22 3 4 4 4]))

; podliste ponavljanja
(defn podlistePonavljanja [lista]
  (if (seq lista)
    (concat
      [(concat [(first lista)] (take-while (partial = (first lista)) (rest lista)))]
      (podlistePonavljanja (drop-while (partial = (first lista)) (rest lista))))
    []))
(println "podlistePonavljanja [1 1 1 1 2 2 2 3 3 3 4] =" (podlistePonavljanja [1 1 1 1 2 2 2 3 3 3 4]))

; ima duplikata
(defn imaDuplikata [lista]
  (if (seq lista)
    (not (apply distinct? lista))
    false))
(println "imaDuplikata [] =" (imaDuplikata []))
(println "imaDuplikata [1 2 2] =" (imaDuplikata [1 2 2]))

; uzastopni parovi; koristimo funkciju parOdListi iz zadataka 3.14
(defn parOdListi [lista1 lista2]
  (if (or (empty? lista1) (empty? lista2))
    []
    (concat [[(first lista1) (first lista2)]] (parOdListi (rest lista1) (rest lista2)))))
    
(defn uzastopniParovi [lista]
  (if (= 1 (count lista))
    (concat lista lista)
    (parOdListi lista (rest lista))))
(println "uzastopniParovi [] =" (uzastopniParovi []))
(println "uzastopniParovi [1] =" (uzastopniParovi [1]))
(println "uzastopniParovi [1 2 3 4] =" (uzastopniParovi [1 2 3 4]))

; broj od liste
(defn broj [lista]
  (if (seq lista)
    (+' (*' (broj (rest lista)) 10) (first lista)) ; +' i *' podrzavaju proizvoljnu preciznost (BigInt)
    0))
(println "broj [1 2 3] =" (broj [1 2 3]))

; obrnuto od broj, moze i (broj (rseq [1 2 3]))
(defn broj1 [lista]
  (if (seq lista)
    (+' 
      (*' 
        (first lista) 
        ; repeat generise listu i kojoj je samo jedna vrednost koja se ponavlja
        (reduce *' (repeat (count (rest lista)) 10))) ; = 10^(count (rest lista)), jer Clojure nema stepenovanje kao deo core funkcija
      (broj1 (rest lista)))
    0))
(println "broj1 [1 2 3] =" (broj1 [1 2 3]))
