; suma kvadrata negativnih elemenata liste
(defn sumaKvNeg [lista]
  (reduce + 0 (map (fn [x] (* x x)) (filter neg? lista))))
(println "sumaKvNeg [-1 -2 3 4 -5] =" (sumaKvNeg [-1 -2 3 4 -5]))

; brojac malih slova
(defn malaSlova [lista]
  ; koristimo metodu iz Java klase Character, jer Clojure ne podrzava implicitnu konverziju iz karaktera u broj pa ne mozemo da koristimo < i >, niti ima ove funkciju ugradjenu u sam jezik
  ; alternativa bi bila pretraga putem regularnih izraza
  (count (filter #(Character/isLowerCase %1) lista))) ; #() je skraceni zapis za anonimnu funkciju, gde je % (%1) prvi argument koji joj je prosledjen
(println "malaSlova \"nEsTo\" =" (malaSlova "nEsTo"))
(println "malaSlova [\\n \\E \\s \\T \\o] =" (malaSlova [\n \E \s \T \o]))

; lista suma svih elemenata podlisti
(defn sume [lista]
  (map (partial reduce +) lista))
(println "sume [[1 2] [3 4 5] [6 7 8 9]] =" (sume [[1 2] [3 4 5] [6 7 8 9]]))

; nasa implementacija sistemske funkcije flatten, s tim sto flatten sabija sve nivoe, dok nasa smanjuje nivo za jedan
(defn spoji [lista]
  (reduce concat [] lista))
(println "spoji [[1 1] [2 2 2] [3 3 3]]) =" (spoji [[1 1] [2 2 2] [3 3 3]]))

; lista u par
(defn listaUPar [lista]
  (loop [left []
         right []
         l lista]
    (if (empty? l)
      [left right]
      (recur (conj left (first (first l))) (conj right (second (first l))) (rest l)))))
(println "listaUPar [[1 2] [1 2] [1 2]] =" (listaUPar [[1 2] [1 2] [1 2]]))
(println "listaUPar [[1 2] [3 4] [5 6]] =" (listaUPar [[1 2] [3 4] [5 6]]))

; par od listi - sistemska zipmap ("zipuj u mapu"), s tim sto mapa uklanja duplikate kljuceva (prva lista)
(defn parOdListi [lista1 lista2]
  (if (or (empty? lista1) (empty? lista2))
    []
    (concat [[(first lista1) (first lista2)]] (parOdListi (rest lista1) (rest lista2)))))
(println "parOdListi [1 2 3] [4 5 6] =" (parOdListi [1 2 3] [4 5 6]))
(println "parOdListi [1 2] [4 5 6] =" (parOdListi [1 2] [4 5 6]))

; ucesljaj - sistemska interleave, ali interleave staje kada se jedna od listi isprazni
(defn ucesljaj [lista1 lista2]
  (if (or (empty? lista1) (empty? lista2))
    (concat lista1 lista2) ; ovo je ekvivalentno sa vracanjem jedne od listi koja nije prazna; ako su obe prazne dobijamo praznu listu
    (concat [(first lista1)] [(first lista2)] (ucesljaj (rest lista1) (rest lista2)))))
(println "ucesljaj [1 2 3] [4 5 6] =" (ucesljaj [1 2 3] [4 5 6]))
(println "ucesljaj [1] [4 5 6] =" (ucesljaj [1] [4 5 6]))