; broj pozitivnih u listi
(defn brojPoz [lista]
  (count (filter pos? lista)))
(println "brojPoz [1 2 3 -4 -5 -6] =" (brojPoz [1 2 3 -4 -5 -6]))
(println "brojPoz [1 2 3 4 5 6] =" (brojPoz [1 2 3 4 5 6]))

; eliminisi proste
; unapredjenje verzije iz zadatka 3.4: trazimo delioce iz opsega [2, n/2] => (range 2 (n+1)/2)
(defn prost? [n] ; ? se cesto stavlja na kraj predikata (funkcija koje vracaju true/false)
  (empty? (filter (fn [x] (= (mod n x) 0)) (range 2 (/ (+ n 1) 2)))))
  
(defn eliminisiProste [lista]
  (remove prost? lista))
(println "eliminisiProste (range 1 100) =" (eliminisiProste (range 1 100)))

; sabiranje apsolutnih vrednosti brojeva iz liste
; prvo moramo da definisemo funkciju abs, jer iz nekog razloga nisu nasli za shodno da ona bude deo osnove jezika
(defn abs [x]
  (if (neg? x)
    (-' x)
    x))

(defn saberiAbs [lista]
  (reduce + (map abs lista)))
(println "saberiAbs [1 2 3 -4 -5 -6] =" (saberiAbs [1 2 3 -4 -5 -6]))

; nadovezi proizvod podliste na nju
(defn nadoveziProizvod [lista]
  (map 
    (fn [x]
      (conj x (reduce * x))) lista))
(println "nadoveziProizvod [[1 2] [3 4] [5 6]] =" (nadoveziProizvod [[1 2] [3 4] [5 6]]))

; prosek liste
(defn prosek [lista]
  (/ (* (reduce + lista) 1.0) (count lista))) ; mnozimo sa 1.0 kako bismo rezultat dobili u decimalnom umesto u razlomljenom obliku
(println "prosek [1 2 5 6 10] =" (prosek [1 2 5 6 10]))
(println "prosek (range 1 10) =" (prosek (range 1 10)))

; broj ponavljanja broja x u listi
(defn brojPonavljanja [x lista]
  (count (filter #(= x %1) lista)))
(println "brojPonavljanja 1 [1 1 2 1 2 2 5 5 1] =" (brojPonavljanja 1 [1 1 2 1 2 2 5 5 1]))