; proizvod prvih n
(defn proizvodPrvih [n] 
  (reduce * (range 1N (inc n)))) ; range daje brojeve iz opsega [start,kraj), pa moramo da uzmemo da je kraj za 1 veci
(println "proizvodPrvih 3 =" (proizvodPrvih 3))
(println "proizvodPrvih 100 =" (proizvodPrvih 100))

; da li je broj prost
; funkcija radi tako sto proverava da li je lista dobijena primenom filtera prazna
; prazna lista oznacava da broj nema pravog delioca u opsegu [2,n) => broj je prost
(defn prost [n]
  (empty? (filter (fn [x] (= (mod n x) 0)) (range 2 n))))
(println "prost 10 =" (prost 10))
(println "prost 97 =" (prost 97))

; najveci zajednicki delilac
(defn nzd [a b]
  (if (= b 0)
    a ; izlaz iz rekurzije i povratna vrednost
    (recur b (mod a b)))) ; recur radi iterativnu rekurziju: ne koristi stek vec samo menja argumente i ponovo prolazi kroz telo funkcije
(println "nzd 15 150 =" (nzd 15 150))
(println "nzd 15 160 =" (nzd 15 160))

; tip kvadratne jednacine
(defn tipJednacine [a b c] 
  (if (= a 0)
    "Degenerisana"
    (if (= (- (* b b) (* 4 a c)) 0)
      "Jedno resenje"
      (if (> (- (* b b) (* 4 a c)) 0)
        "Dva resenja"
        "Nema resenja"))))
(println "tipJednacine 1 2 3" (tipJednacine 1 2 3))
(println "tipJednacine 3 2 1" (tipJednacine 3 2 1))
(println "tipJednacine 2 2 0" (tipJednacine 2 2 0))

; konvertuje u dekadnu osnovu
(defn uDekadnu [x osn]
  (loop [x x ; definisemo ulaznu tacku petlje i lokalne promenjljive
         o 1
         r 0]
    (if (= x 0)
      r
      (recur (quot x 10) (* o osn) (+ r (* o (mod x 10))))))) ; recur nas vraca na ulaznu tacku kojoj pripada (funkcija ili loop)
      ; quot(ient) - celobrojno deljenje
(println "uDekadnu 772 8 =" (uDekadnu 772 8))
(println "uDekadnu 101000101 2 =" (uDekadnu 101000101 2))

; konvertuje iz dekadne osnove
(defn izDekadne [x osn]
  (loop [x x
         o 1
         r 0]
    (if (= x 0)
      r
      (recur (quot x osn) (* o 10) (+ r (* o (mod x osn)))))))
(println "izDekadne 506 8 =" (izDekadne 506 8))
(println "izDekadne 325 2 =" (izDekadne 325 2))
      
; ceo deo korena od x
(defn ceoDeo [x]
  (loop [x x
         i 1]
    (if (> (* i i) x)
      (dec i)
      (recur x (inc i)))))
(println "ceoDeo 2 =" (ceoDeo 2))
(println "ceoDeo 100 =" (ceoDeo 100))
(println "ceoDeo 99 =" (ceoDeo 99))      