; lista elemenata harmonijskog niza od n
(defn harm [n]
  (loop [niz []
         x 1]
    (if (= x (inc n))
      niz
      (recur (conj niz (/ x)) (inc x))))) ; (/ x) = 1/x
(println "harm 10 =" (harm 10))
(println "harm 100 =" (harm 100))

; harmonijski niz u pokretnom zarezu
(defn harmDec [n]
  (loop [niz []
         x 1.0]
    (if (== x (inc n)) ; == proverava jednakost vrednosti bez obzira na tip
      niz
      (recur (conj niz (/ x)) (inc x)))))
(println "harmDec 10 =" (harmDec 10))

; lista svih delilaca broja n; delilac x je broj za koji je (mod n x) = 0
(defn delioci [n]
  (if (= n 1)
    [1]
    (filter (fn [x] (= (mod n x) 0)) (range 2 n)))) ; izbacujemo 1 i n, jer se oni podrazumevaju
(println "delioci 3 =" (delioci 3))
(println "delioci 100 =" (delioci 100))

; nadovezivanje liste2 n-puta na listu1
(defn nadovezi [lista1 lista2 n]
  (loop [x 1
         lista (concat lista1 lista2)]
    (if (= x n)
      lista
      (recur (inc x) (concat lista lista2))))) ; concat, za razliku od conj(oin) radi samo sa kolekcijama (vektorima i listama)
(println "nadovezi [1 2] [3 4] 3 =" (nadovezi [1 2] [3 4] 3))