; vraca praznu listu ako je lista prazna, inace rep liste
(defn bezbedanRep [lista]
    (rest lista))
(println "bezbedanRep [] =" (bezbedanRep []))
(println "bezbedanRep [1] =" (bezbedanRep [1]))
(println "bezbedanRep [1 2 3] =" (bezbedanRep [1 2 3]))

; vraca listu savrsenih brojeva manjih od n; ovo je moglo da se spakuje u jednu kompoziciju funkcija,
; ali je zbog preglednosti razdvojeno u 2
(defn faktori [n]
  (if (= n 1)
    [1]
    (filter (fn [x] (= (mod n x) 0)) (range 1 n))))
    
(defn savrseni [n]
  (filter (fn [x] (= (reduce + (faktori x)) x)) (range 1 n)))
(println "savrseni 10 =" (savrseni 10))
(println "savrseni 10000 =" (savrseni 10000))

; vraca listu parova takvih da im je zbir jednak n
(defn zbirPar [n]
  (for [i (range 1 n)] [i (- n i)]))
(println "zbirPar 10 =" (zbirPar 10))
  
; polovina liste
(defn polovina [lista]
  (split-at (quot (count lista) 2) lista))
(println "polovina [1 2 3 4]=" (polovina [1 2 3 4]))
(println "polovina [1 2 3 4 5]=" (polovina [1 2 3 4 5]))

; poslednji u listi
(defn poslednji [lista]
  (last lista))
(println "poslednji [1 2 3 4]=" (poslednji [1 2 3 4]))

; spaja listu listi u jednu listu
(defn spoji [lista]
  (flatten lista))
(println "spoji [[1 2] [3 4] [5 6]]=" (spoji [[1 2] [3 4] [5 6]]))

; lista svih sufiksa
(defn sufiksi [lista]
  (loop [res (conj [] lista)
         tail lista]
    (if (next tail) ; ako postoji jos nesto dodaj sufiks
    ; next vraca nil ako je tail prazno (rest tada vraca praznu listu), pa se moze iskoristiti u uslovu
      (recur (conj res (vec (rest tail))) (rest tail))
      res)))
(println "sufiksi [1 2 3 4] =" (sufiksi [1 2 3 4]))
;(println "sufiksi [1 2 3 4 5 6 7 8 9 10] =" (sufiksi [1 2 3 4 5 6 7 8 9 10]))

; obrtanje liste
(defn obrni [lista]
  (rseq lista)) ; moze i reverse, ali je rseq brza funkcija
(println "obrni [1 2 3] =" (obrni [1 2 3]))

; izbacivanje k-tog elementa iz liste; odnosno, zadrzavanje svih ostalih elemenata; indeksi krecu od 0
(defn izbaci [k lista]
  (keep-indexed (fn [i v] (if (not= k i) v)) lista))
(println "izbaci 3 [1 2 3 4 5 6] =" (izbaci 3 [1 2 3 4 5 6]))

; dupliranje svakog elementa liste
(defn duplira [lista]
  (interleave lista lista))
(println "duplira [1 2 3] =" (duplira [1 2 3]))

; ubaci n u listu na poziciju k
(defn ubaci [k n lista]
  (let [[start end] (split-at k lista)] ; start i end su vektori rezultat funkcije split-at
    (concat start [n] end)))
(println "ubaci 3 10 [1 2 3 4] =" (ubaci 3 10 [1 2 3 4]))
(println "ubaci 3 10 [] =" (ubaci 3 10 []))

; izbaci svaki n-ti iz liste, tj. zadrzi sve ostale
(defn izbaciSvaki [n lista]
  (keep-indexed (fn [i v] (if (not= 0 (mod (+ i 1) n)) v)) lista))
(println "izbaciSvaki 3 (range 1 10) =" (izbaciSvaki 3 (range 1 10)))
