import sys
from logic import *

#Theaters for crawling
theaters = [{"Name": "Narodno Pozoriste", "url": "http://www.narodnopozoriste.rs/en/repertoire"},
            {"Name": "Pozoriste Slavija", "url": "http://www.pozoriste-slavija.co.rs/"},
            {"Name": "Madlenianum", "url": "http://operatheatremadlenianum.com/repertoar/month"},]


scriptUsage = "pmk.py [[f n a d] criterion] [days]"

# TODO refaktorisi
if len(sys.argv) == 1:
    # list all events from all theaters
    [pmkList(theater) for theater in theaters]
elif len(sys.argv) == 2 and sys.argv[1] == 'd':
    # find events for today
    [pmkFindByDate(theater, datetime.now().strftime("%d.%m.%Y"), 0) for theater in theaters]
elif len(sys.argv) == 3:
    if sys.argv[1] == 'f':
        # find
        [pmkFind(theater, sys.argv[2]) for theater in theaters]
    elif sys.argv[1] == 'n':
        # find by name
        [pmkFindByName(theater, sys.argv[2]) for theater in theaters]
    elif sys.argv[1] == 'a':
        # find by author
        [pmkFindByAuthor(theater, sys.argv[2]) for theater in theaters]
    elif sys.argv[1] == 'd':
        # find events on specific date
        [pmkFindByDate(theater, sys.argv[2], 0) for theater in theaters]
    else:
        print scriptUsage
        exit()
elif len(sys.argv) == 4 and sys.argv[1] == 'd' and sys.argv[3].isdigit():
    [pmkFindByDate(theater, sys.argv[2], int(sys.argv[3])) for theater in theaters]
else:
    print scriptUsage
    exit()


