import dateutil.parser
import re


def printElementText(e, prefix):
    if e is not None and e.text is not None:
        print prefix + e.text
    else:
        print prefix + "/"

def printAttributeValue(e, attr):
    if e is not None:
        print e.get(attr)
    else:
        print "/"

def printInstitution(name):
    print "\n\n====================================="
    print "  " + name.upper()
    print "=====================================\n"

def printSingleEvent(name, genre, author, date):

    if name == "/" or date == "/":
        print ""
    else:
        datum = dateutil.parser.parse(date)

        print "-----------------------------------"
        print u' '.join(("    Ime: " , name)).encode('utf-8').strip()
        print u' '.join(("    Zanr: " , genre)).encode('utf-8').strip()
        print u' '.join(("    Datum: " , str(datum.strftime("%d.%m.%Y. u %H:%M:%S\n")))).encode('utf-8').strip()
        print u' '.join(("    Autor: " , author)).encode('utf-8').strip()
        print "-----------------------------------"

# name, genre, author, date
def printSingleEventFromList(info):
    printSingleEvent(info[0], info[1], info[2], info[3])


def printStringPrefix(string, prefix):
    if string is not None:
        print prefix + string
    else:
        print prefix + "/"

