local M = {}

M.map = {}

M.score=0

M.map.width = 0
M.map.height = 0
--Predefinisane boje
M.color = {}
M.color.r = 255
M.color.g = 255
M.color.b = 255
M.color.a = 100
--Promenljive koje opisuju boju loptice na odredjenom polju
M.const = {}
M.const.empty = 0
M.const.red = 1
M.const.green = 2
M.const.blue = 3
M.const.yellow = 4
M.const.roze = 5
--Predefinisane boje za hover
M.colorHover = {}
M.colorHover.r = 0
M.colorHover.g = 100
M.colorHover.b = 200
M.colorHover.a = 100

Mwidth = 50
Mheight = 50
--Pozivanje modula krugovi pomocu kojeg postavljamo loptice odredjenih boja
k = require("krugovi")
--Funkcija koja generise pocetnu mapu na koju upisujemo 3 loptice, i svakom polju dodeljuje parametre
--vrednost polje, hover, i visited koji se koristi za DFS
function M.generisi(width, height)
  M.score=0
  for i = 1, width do
    M.map[i] = {}
    for j = 1, height do
      M.map[i][j] = {}
      M.map[i][j].val = M.const.empty
      M.map[i][j].hover = false
      M.map[i][j].visited = 0
    end
  end
  generisiPocetno(width, height, 3)
  M.map.width = width
  M.map.height = height
end
--Funkcija koja generise random boju loptice na tri random prazna polja
--Kada se generise svaka od novih loptica proverava se da li ona zadovoljava
--uslov da sa postojecim lopticama na mapi, da ih ima 5 ili vise u nizu,
--ukoliko zadovoljava taj uslov brise se tih 5(ili vise)
function generisiPocetno(w, h, n)
  while n > 0 do
    local x = math.random(w)
    local y = math.random(h)
    local kuglica = math.random(5)
    if M.map[x][y].val == M.const.empty then
      M.map[x][y].val = kuglica
      n = n - 1
    end
    unistavanjeX(x,y)
    unistavanjeY(x,y)
  end
end
--Funkcija koja nam vraca koordinate polja u mapi, ukoliko je kliknuto van
--nekog od polja funkcija vraca kao koordinate -1,-1
function M.mouse(x, y)
  local mouseX, mouseY = x, y
  local selectedX = -1
  local selectedY = -1
  for i = 1, M.map.width do
    isx = mouseX > (i - 1) * Mwidth and mouseX < i * Mwidth
    for j = 1, M.map.height do
      isy = mouseY > (j - 1) * Mheight and mouseY < j * Mheight
      if isx and isy then
        M.map[i][j].hover = true
        print(i,j)
        selectedX, selectedY = i, j
      else
        M.map[i][j].hover = false
      end
    end
  end
  return selectedX, selectedY
end
--Funkcija koja iscrtava mapu, prvo se iscrtavaju pravougaonici koji
--predstavljaju polja, zatim preko njih se iscrtavaju loptice odredjenih boja
function M.draw()
  for j = 1, M.map.height do
    for i = 1, M.map.width do
      if M.map[i][j].hover == false then
        love.graphics.setColor(M.color.r, M.color.g, M.color.b, M.color.a)
      else
        love.graphics.setColor(M.colorHover.r, M.colorHover.g, M.colorHover.b, M.colorHover.a)
      end
      love.graphics.rectangle("fill", (i - 1) * Mwidth, (j - 1) * Mheight, Mwidth - 1, Mwidth - 1)
    end
  end


  for j = 1, M.map.height do
    for i = 1, M.map.width do
      --draw red
      if M.map[i][j].val == M.const.red then
        w = k.krugovi[1]:getWidth()
        h = k.krugovi[1]:getHeight()
        x = (Mwidth - 1) / w
        y = (Mheight - 1) / h
        love.graphics.draw(k.krugovi[1], (i - 1) * Mwidth + 1, (j - 1) * Mheight - 1, x, y)
        --draw green
      elseif M.map[i][j].val == M.const.green then
        w = k.krugovi[2]:getWidth()
        h = k.krugovi[2]:getHeight()
        x = (Mwidth - 1) / w
        y = (Mheight - 1) / h
        love.graphics.draw(k.krugovi[2], (i - 1) * Mwidth + 1, (j - 1) * Mheight - 2, x, y)
        --draw blue
      elseif M.map[i][j].val == M.const.blue then
        w = k.krugovi[3]:getWidth()
        h = k.krugovi[3]:getHeight()
        x = (Mwidth - 1) / w
        y = (Mheight - 1) / h
        love.graphics.draw(k.krugovi[3], (i - 1) * Mwidth + 5.2, (j - 1) * Mheight - 4, x, y)
        --draw yellow
      elseif M.map[i][j].val == M.const.yellow then
        w = k.krugovi[4]:getWidth()
        h = k.krugovi[4]:getHeight()
        x = (Mwidth - 1) / w
        y = (Mheight - 1) / h
        love.graphics.draw(k.krugovi[4], (i - 1) * Mwidth + 3, (j - 1) * Mheight - 2, x, y)
        --draw pink
      elseif M.map[i][j].val == M.const.roze then
        w = k.krugovi[5]:getWidth()
        h = k.krugovi[5]:getHeight()
        x = (Mwidth - 1) / w
        y = (Mheight - 1) / h
        love.graphics.draw(k.krugovi[5], (i - 1) * Mwidth + 2.8, (j - 1) * Mheight - 0.5, x, y)
      end
    end
  end
end
--Funkcija koja premesta lopticu sa polja (x,y) na polje (x1,y1), ali pod odgovarajucim uslovima
--Da postoji put do izmedju ta dva polje, da je polje (x1,y1) prazno
function M.premesti(x, y, x1, y1)
  --provera da li je polje (x1,y1) prazno
  if M.map[x1][y1].val ~= M.const.empty then
    return
  end
  --postavljenje visited elementa na 0, za potreba DFS pretrage
  for i = 1, 10 do
    for j = 1, 10 do
      M.map[i][j].visited = 0
    end
  end
  --ispitivanje da li je postoji put izmedju (x,y) i (x1,y1)
  if dozvoljeno(x, y, x1, y1) ~= 1 then
    local title = "Warning!"
    local message = "Invalid move!"
    success = love.window.showMessageBox( title, message,"info", true )
    return
  end
  --Postavljenje vrednosti polje (x1,y1) na vrednost polja (x,y)
  --Resetovanje polja (x,y) na const.empty
  M.map[x1][y1].val = M.map[x][y].val
  M.map[x][y].val = 0
  --Ukoliko sa tom prebacenom lopticom postoji 5 ili vise u nizu po X osi, prebrisi
  if unistavanjeX(x1, y1) ~= 1 then
    --Ukoliko sa tom prebacenom lopticom postoji 5 ili vise u nizu po Y osi, prebrisi
    if unistavanjeY(x1, y1) ~= 1 then
      --Ukoliko sa tim potezom nije dovelo do 5 ili vise u nizu, generisi 3 nove loptice
      --na random praznim poljima
      generisiPocetno(10, 10, 3)
    end
  end
end
--Implementacija DFS pretrage
function dozvoljeno(x, y, x1, y1)
  print(x, y)
  q = 0
  M.map[x][y].visited = 1
  if x == x1 and y == y1 then
    return 1
  end
  if x > 1 then
    if M.map[x - 1][y].visited == 0 then
      if M.map[x - 1][y].val == 0 then
        if dozvoljeno(x - 1, y, x1, y1) == 1 then
          return 1
        end
      end
    end
  end
  if y > 1 then
    if M.map[x][y - 1].visited == 0 then
      if M.map[x][y - 1].val == 0 then
        if dozvoljeno(x, y - 1, x1, y1) == 1 then
          return 1
        end
      end
    end
  end
  if x < 10 then
    if M.map[x + 1][y].visited == 0 then
      if M.map[x + 1][y].val == 0 then
        if dozvoljeno(x + 1, y, x1, y1) == 1 then
          return 1
        end
      end
    end
  end
  if y < 10 then
    if M.map[x][y + 1].visited == 0 then
      if M.map[x][y + 1].val == 0 then
        if dozvoljeno(x, y + 1, x1, y1) == 1 then
          return 1
        end
      end
    end
  end
  return 0
end
--Funkcija koja vrsi oznacavanje ukoliko ima 5 ili vise loptica iste boje u nizu po X osi,
--u odnosu na koordinate zadatog polja
function unistavanjeX(x, y)
  start = x
  finish = x
  ball = M.map[x][y].val
  for i = x + 1, M.map.width do
    if M.map[i][y].val ~= ball or M.map[i][y].val == 0 then
      break
    else
      finish = finish + 1
    end
  end
  for i = x - 1, 1, - 1 do
    if M.map[i][y].val ~= ball or M.map[i][y].val == 0 then
      break
    else
      start = start - 1
    end
  end
  if (finish - start + 1) >= 5 then
    brisanjepoX(start, finish, y)
    return 1
  end
end
--Funkcija koja vrsi oznacavanje ukoliko ima 5 ili vise loptica iste boje u nizu po Y osi,
--u odnosu na koordinate zadatog polja
function unistavanjeY(x, y)
  start = y
  finish = y
  ball = M.map[x][y].val
  for i = y + 1, M.map.height do
    if M.map[x][i].val ~= ball or M.map[x][i].val == 0 then
      break
    else
      finish = finish + 1
    end
  end
  for i = y - 1, 1, - 1 do
    if M.map[x][i].val ~= ball or M.map[x][i].val == 0 then
      break
    else
      start = start - 1
    end
  end
  if (finish - start + 1) >= 5 then
    brisanjepoY(start, finish, x)
    return 1
  end
end
--Funkcija koja vrsi brisanje po X osi od x koordinate start do x koordinate finish, y je fiksirano
function brisanjepoX(start, finish, y)
  for i = start, finish do
    M.map[i][y].val = 0
  end
  --Ukoliko se veze vise od 5 loptica iste boje u nizu, dobija se 3 + 2 ekstra poena, inace samo 3
  if (finish-start +1)>5 then
    M.score=M.score+5
    local title = "Success!"
    local message = "You just got 2 extra points!"
    success = love.window.showMessageBox( title, message,"info", true )
  else
    M.score=M.score+3
  end
end
--Funkcija koja vrsi brisanje po Y osi od y koordinate start do y koordinate finish, x je fiksirano
function brisanjepoY(start, finish, x)
  for i = start, finish do
    M.map[x][i].val = 0
  end
  --Ukoliko se veze vise od 5 loptica iste boje u nizu, dobija se 3 + 2 ekstra poena, inace samo 3
  if (finish-start +1)>5 then
    local title = "Success!"
    local message = "You just got 2 extra points!"
    success = love.window.showMessageBox( title, message,"info", true )
    M.score=M.score+5
  else
    M.score=M.score+3
  end
end
--Funkcija koja proverava da li smo dosli do kraja igre
function M.popunjeno()
  count=0
  for j = 1, M.map.height do
    for i = 1, M.map.width do
      if M.map[i][j].val==M.const.empty then
        count=count+1
      end
    end
  end
  if count<3 then
    return 1
  else
    return 0
  end
end
--Funkcija koja vraca broj poena osvojenih u igri
function M.getScore()
  return M.score
end

return M
