import tkinter as tk
from PIL import Image, ImageTk
from itertools import count
from speechrecognition import SpeechRecognition
from speech import say


class ImageLabel(tk.Label):
    """
   Class that displays moving gifs.
   """

    def load(self, im):
        if isinstance(im, str):
            im = Image.open(im)

        self.loc = 0
        self.frames = []

        try:
            for i in count(1):
                self.frames.append(ImageTk.PhotoImage(im.copy()))
                im.seek(i)
        except EOFError:
            pass

        try:
            self.delay = im.info['duration']
        except:
            self.delay = 100

        if len(self.frames) == 1:
            self.config(image=self.frames[0])
        else:
            self.next_frame()

    def unload(self):
        self.config(image=None)
        self.frames = None

    def next_frame(self):
        if self.frames:
            self.loc += 1
            self.loc %= len(self.frames)
            self.config(image=self.frames[self.loc])
            self.after(self.delay, self.next_frame)


class Gui:
    def __init__(self):
        self.sr = SpeechRecognition()

    def start(self):
        root = tk.Tk()
        root.title("Imaginary Friend 1.0")
        label = ImageLabel(root)
        label.pack()
        label.load('robot.gif')
        tk.Button(root, text="Talk to me!", command=self.sr._recognizer).pack()

        def greetings():
            say("Hello. How can I help you? Press the button and say your command!")

        root.after(500, greetings)
        root.mainloop()
