from datetime import datetime
import geocoder
from grab import Grab
import re
import os
import time
import ujson
import webbrowser
import speech_recognition as sr
from speech import say


class SpeechRecognition:
    def __init__(self):
        self.r = sr.Recognizer()
        self.matched = False
        functions = Functions()
        self.functions = functions.functions

    def _recognizer(self):
        with sr.Microphone() as mic:
            self.r.adjust_for_ambient_noise(mic, duration=2)

            print("Say something!")
            self.audio = self.r.listen(mic)

        try:
            self.command = self.r.recognize_sphinx(self.audio)
            print("I think you said: {0}".format(self.command))
            self.do(self.command)
        except sr.UnknownValueError:
            print("Sphinx error")
        except sr.RequestError as e:
            print("Sphinx error: {0}".format(e))

    def do(self, command):
        for (com, func) in self.functions.items():
            if com == command:
                self.matched = True
                func()
            elif self.match(com, command):
                say("I think you wanted me to do this: {0}".format(com))
                say("Do you want me to do that?")

                answer = local_recognizer()

                if answer == "yes":
                    self.matched = True
                    func()
                else:
                    say("Then I can not understand your command. Try again?")
        if not self.matched:
            say("I did not understand that. Can you repeat your command?")
        self.matched = False

    def match(self, com1, com2):
        return True if com1 in com2 else False


class Functions:
    def __init__(self):
        self.g = Grab()
        self.functions = {
            "shut down" : self._shutdown,
            "restart" : self._restart,
            "bash" : self._terminal,
            "time" : self._time,
            "date" : self._date,
            "location" : self._location,
            "mail" : self._mail,
            "facebook" : self._facebook,
            "youtube" : self._youtube,
            "internet browser" : self._browser,
            "news" : self._news,
            "what is your name" : self._name,
            "who made you" : self._us,
            "are you alive" : self._alive,
            "when is your birthday" : self._birthday,
            "listen to this song" : self._play_me_a_song,
            "weather" : self._weather,
            "the latest articles" : self._latest_news
        }

    def _shutdown(self):
        os.system("poweroff")

    def _restart(self):
        os.system("reboot")

    def _terminal(self):
        os.system("konsole")

    def _time(self):
         say(datetime.now().strftime('The time is %H hours, %M minutes, %S seconds'))

    def _date(self):
        say(datetime.now().strftime('Today is %A, %dth of %B, %Y'))

    def _location(self):
        g = geocoder.ip('me')
        say("You are now in {}, {}".format(g.city, g.state))

    def _mail(self):
        webbrowser.open('https://www.google.com/gmail/', new=2)

    def _facebook(self):
        webbrowser.open('https://www.facebook.com/', new=2)

    def _youtube(self):
        webbrowser.open('https://www.youtube.com/', new=2)


    def _browser(self):
        webbrowser.open('https://www.google.com/', new=2)

    def _news(self):
        webbrowser.open('http://www.bbc.com/news', new=2)

    def _name(self):
        say("My name is Imaginary Friend.")

    def _us(self):
        say("I was made by Meelosh and Deeanah")

    def _birthday(self):
        say("My birthday is on 13th of May")

    def _alive(self):
        say("I might be. What do you think?")

    def _play_me_a_song(self):
        say("Please tell me the song title!")

        answer = local_recognizer()

        self.g.go('https://www.youtube.com/results?search_query={}'.format(answer))
        song_data = ujson.loads(re.search(r'window\["ytInitialData"\] = (.+?);', self.g.doc.body.decode()).group(1))

        for video in \
            song_data['contents']['twoColumnSearchResultsRenderer']['primaryContents']['sectionListRenderer'][
                    'contents'][0]['itemSectionRenderer']['contents']:
            if answer.upper() in video['videoRenderer']['title']['simpleText'].upper():
                webbrowser.open('https://www.youtube.com/watch?v={}'.format(video['videoRenderer']['videoId']))
                break

    def _weather(self):
        self.g.go('https://www.accuweather.com/en/rs/belgrade/298198/current-weather/298198')
        forecast = self.g.doc.select('//div[@class="forecast"]/div[@class="info"]').text()
        text = forecast.split()
        temp = text[0][:-1]
        realf = text[2][:-1]
        info = ' '.join(text[3:])
        weather = ' '.join(['Temperature', temp, 'degrees.', 'Real feel', realf, 'degrees.', 'Additional information.', info])
        say(weather)

    def _latest_news(self):
        self.g.go('http://www.bbc.com/news')
        articles = self.g.doc.select('//ol[contains(@class, "gel-layout__item")]').text()
        title1 = re.sub(r'[\'\"]', '', re.search(r'1(.+?)2[^0-9]', articles).group(1))
        title2 = re.sub(r'[\'\"]', '', re.search(r'2([^0-9].+?)3[^0-9]', articles).group(1))
        title3 = re.sub(r'[\'\"]', '', re.search(r'3([^0-9].+?)4[^0-9]', articles).group(1))

        l1 = self.g.doc.select(
            """//ol[contains(@class, 'gel-layout__item')]/li[contains(@data-entityid, 'most-popular-read-1')]/
            span[contains(@class, 'gs-o-media')]/div[contains(@class, 'gs-o-media__body')]/a""").attr('href')

        l2 = self.g.doc.select(
            """//ol[contains(@class, 'gel-layout__item')]/li[contains(@data-entityid, 'most-popular-read-2')]/
            span[contains(@class, 'gs-o-media')]/div[contains(@class, 'gs-o-media__body')]/a""").attr('href')

        l3 = self.g.doc.select(
            """//ol[contains(@class, 'gel-layout__item')]/li[contains(@data-entityid, 'most-popular-read-3')]/
            span[contains(@class, 'gs-o-media')]/div[contains(@class, 'gs-o-media__body')]/a""").attr('href')

        link1 = 'https://www.bbc.com/{}'.format(l1)
        link2 = 'https://www.bbc.com/{}'.format(l2)
        link3 = 'https://www.bbc.com/{}'.format(l3)

        news = {title1: link1,
                title2: link2,
                title3: link3}

        self._read_news(news)

    def _read_news(self, news):
        say('Here are top 3 articles on BBC news site.')
        for (n, link) in news.items():
            say(n)
            print(n)
            say('Do you want me to open this article?')

            answer = local_recognizer()

            if answer == "yes":
                webbrowser.open(link)
                time.sleep(3)
            else:
                say("Okay.")


def local_recognizer():
    r2 = sr.Recognizer()

    with sr.Microphone() as mic:
        r2.adjust_for_ambient_noise(mic, duration=2)
        print("Say something!")
        audio = r2.listen(mic)

    try:
        answer = r2.recognize_sphinx(audio)
        print("I think you said: {0}".format(answer))

        return answer
    except sr.UnknownValueError:
        print("Sphinx error")
    except sr.RequestError as e:
        print("Sphinx error: {0}".format(e))
