# Hip (red sa prioritetom)
# Biblioteka heapq, odeljak zvanične dokumentacije:
# https://docs.python.org/3.7/library/heapq.html
# Heap queue is a special tree structure in which each parent node is less than
# or equal to its child node.In pythin it is implemented using the heapq module.
# It is very useful is implementing priority queues where the queue item
# with higher weight is given more priority in processing.
# Functions:
# * heapify – This function converts a regular list to a heap.
# * heappush – This function adds an element to the heap without altering the current heap
# * heappop – This function returns the smallest data element from the heap.
# * heapreplace – This function replaces the smallest data element with a new value supplied in the function.
import heapq

# Max heap
H = [21,1,45,78,3,5]
# Use heapify to rearrange the elements
heapq.heapify(H)
print(H)
heapq.heappush(H,8)
print(H)

# Heapsort
def heapsort(iterable):
    h = []
    for value in iterable:
        heapq.heappush(h, value)
    return [heapq.heappop(h) for i in range(len(h))]
print(heapsort([1, 3, 5, 7, 9, 2, 4, 6, 8, 0]))