"""
    Python klase. Destruktor, promenljive.
"""
class Robot:
    """Represents a robot, with a name."""

    # Mozemo pristupiti dokumentaciji preko __doc__() metoda
    
    population = 0  # class variable

    def __init__(self, name):
        """Initializes the data."""
        self.name = name
        Robot.population += 1
        print(f"{self.name} is created!")

    def __del__(self):
        """Delete instance."""
        print(f"{self.name} is being destroyed!")
        Robot.population -= 1

    def say_hi(self):
        """Simple class method."""
        print(f"Greetings, my masters call me {self.name}.")

    @classmethod
    def how_many(cls):
        """Prints the current population."""
        print(f"We have {cls.population} robots.")

    # postoji i @staticmethod, takve funkcije nemaju parametre
    # koriste se kada nije potrebno da metod pristupa atributima klase


droid1 = Robot("R2-D2")
droid1.say_hi()
Robot.how_many()

droid2 = Robot("C-3PO")
droid2.say_hi()
Robot.how_many()

print("\nRobots can do some work here.\n")

print("Robots have finished their work. So let's destroy them.")
del droid1
del droid2

Robot.how_many()

# REFERENCE:
# https://python.swaroopch.com/oop.html
