"""
    Python klase. Nasledjivanje.
"""
import math

class Shape:
    def __init__(self, color='black', filled=False):
        # protected promenljive pocinju sa _
        # private promenljive pocinju sa __
        # Ovo je samo konvencija o imenovanju, ne postoje zaista privatne promenljive u Pythonu.
        # Radi se o kvazi privatnim, Python promenljivim koje počinju sa __ menja naziv interno, i na taj način vrši skrivanje imena.
        self.__color = color 
        self.__filled = filled
    def get_color(self):
        return self.__color
    def get_filled(self):
        return self.__filled
    def set_filled(self, filled):
        self.__filled = filled


class Rectangle(Shape):
    def __init__(self, length, breadth):
        super().__init__(color='red')
        self.__length = length
        self.__breadth = breadth
    def get_area(self):
        return self.__length * self.__breadth
    def get_perimeter(self):
        return 2 * (self.__length + self.__breadth)


class Circle(Shape):
    def __init__(self, radius):
        super().__init__(color='blue')
        self.__radius = radius
    def get_area(self):
        return math.pi * self.__radius ** 2
    def get_perimeter(self):
        return 2 * math.pi * self.__radius


r1 = Rectangle(10.5, 2.5)
print("Area of rectangle r1:", r1.get_area())
print("Perimeter of rectangle r1:", r1.get_perimeter())
print("Color of rectangle r1:", r1.get_color())
print("Is rectangle r1 filled ? ", r1.get_filled())
r1.set_filled(True)
print("Is rectangle r1 filled ? ", r1.get_filled())

c1 = Circle(12)
print("\nArea of circle c1:", format(c1.get_area(), "0.2f"))
print("Perimeter of circle c1:", format(c1.get_perimeter(), "0.2f"))
print("Color of circle c1:", c1.get_color())
print("Is circle c1 filled ? ", c1.get_filled())
c1.set_filled(True)
print("Is circle c1 filled ? ", c1.get_filled())

"""
Multiple inheritance: 
class A:
    def __init__(self):
        super(A, self).__init__()        
        print('A')
class B:
    def __init__(self):
        super(B, self).__init__()        
        print('B')
class C:
    def __init__(self):
        super(C, self).__init__()        
        print('C')
class X(A, B, C):
    def __init__(self):
        super(X, self).__init__()
x = X()
"""

"""
Overriding:
class A:
    def explore(self):
        print("explore() method from class A")
class B(A):
    def explore(self):
        print("explore() method from class B")
b_obj = B()
a_obj = A()
b_obj.explore()
a_obj.explore()
"""

"""
Overloading:
class Point:
    def __init__(self, x = 0, y = 0):
        self.x = x
        self.y = y 
    def __str__(self):
        return "({0},{1})".format(self.x,self.y)
    def __add__(self,other):
        x = self.x + other.x
        y = self.y + other.y
        return Point(x,y)
p1 = Point(2,3)
p2 = Point(-1,2)
print(p1 + p2)        
"""

# REFERENCE:
# https://overiq.com/python-101/inheritance-and-polymorphism-in-python/