import java.net.URL
import java.io.PrintWriter
import java.io.File

// Dodajemo biblioteku za parsiranje HTML stranica
// http://htmlcleaner.sourceforge.net/index.php
import org.htmlcleaner._

class ParserOsoblja(url : String, path : String) extends Thread {
  override def run() {
    //  Pravimo novi objekat tipa HtmlCleaner koji parsira HTML datoteku sa zadatim url-om
    //  Neki od korisnih metoda klase HtmlCleaner su:
    //  - clean(url) - vraca koreni cvor tipa TagNode sadrzaja datog url-a
    //  - getInnerHtml(cvor) - vraca string - sadrzaj HTML koda datog cvora
    //
    //  Neki od korisnih metoda klase TagNode su:
    //  - getChildTags() - vraca niz dece cvorova tipa TagNode
    //  - hasChildren() - vraca true ukoliko cvor ima dece, false inace
    //  - getAttributeByName(a)  - vraca vrednost atributa a
    //  - getElementsByName(ime, rekurzivno)  - vraca niz dece sa zadatim imenom
    //  - getElementsByAttValue(a, v, rekurzivno, caseSensitive)
    //      - vraca niz dece koja imaju atribut a sa vrednoscu v
    //  - getElementsHavingAttribute(a,rekurzivno)
    //      - vraca niz dece koja imaju atribut a
    //  ...

    val cleaner = new HtmlCleaner()
    val pw : PrintWriter = new PrintWriter(new File(path))

    //  Dohvatamo korenu etiketu - html
    val root = cleaner.clean(new URL(url))

    //  Dohvatamo niz etiketa koje imaju klasu employer
    val elements = root.getElementsByAttValue("class", "employer", true, false)
    for(el <- elements){
      //  Dohvatamo link- `a` etikete jer se u prvoj nalazi ime osobe
      val links = el.getElementsHavingAttribute("href", true)
      //  Dohvatamo div etikete jer se u prvoj nalazi korisnicko ime
      val divs = el.getElementsByName("div", true)
      if(links.length != 0 && divs.length != 0)
        pw.append(links(0).getText + " - " + divs(0).getText + "@matf.bg.ac.rs \n")
    }
    pw.close()
  }
}

object NastavnoOsoblje {
  def main(args : Array[String]) {
    //  Pravimo niz niti koje ce da izvlace email adrese nastavnog osoblja na fakultetu
    val niti = new Array[ParserOsoblja](5)
    niti(0) = new ParserOsoblja("http://www.matf.bg.ac.rs/redovni/", "redovni_profesori.txt")
    niti(1) = new ParserOsoblja("http://www.matf.bg.ac.rs/vanredni/", "vanredni_profesori.txt")
    niti(2) = new ParserOsoblja("http://www.matf.bg.ac.rs/docenti/", "docenti.txt")
    niti(3) = new ParserOsoblja("http://www.matf.bg.ac.rs/asistenti/", "asistenti.txt")
    niti(4) = new ParserOsoblja("http://www.matf.bg.ac.rs/saradnici/", "saradnici.txt")

    //  Pokrecemo niti
    for(i <- 0 until 5)
      niti(i).start()
  }
}
