package com.endava.reactor.reactordemo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;


@RestController
@RequestMapping(value = "/", produces = MediaType.APPLICATION_JSON_VALUE)
public class PlanetController {
    private static final Logger log = LoggerFactory.getLogger(PlanetController.class);

    private final PlanetService planetService;

    public PlanetController(PlanetService planetService) {
        this.planetService = planetService;
    }

    @RequestMapping("/planets")
    public Flux<Planet> getPlanets() {
        log.info("Getting planets");
        return planetService.getPlanets().log();
    }

    @RequestMapping("/planets/{name}")
    public Mono<Planet> getPlanetByName(@PathVariable String name) {
        log.info("Getting planets");
        return planetService.getPlanets()
                .filter(planet -> planet.getName().equalsIgnoreCase(name))
                .log()
                .singleOrEmpty()
                .switchIfEmpty(Mono.error(new ResponseStatusException(HttpStatus.NOT_FOUND)));
    }

    @RequestMapping("/moons")
    public Flux<Moon> getMoons() {
        log.info("Getting moon");
        return planetService.getPlanets()
                .flatMap(planet ->
                        planetService.getMoons()
                                .filter(moon -> moon.getParentPlanet().equals(planet.getName())))
                .log();
    }

}
