package com.endava.reactor.reactordemo;

import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

import java.time.Year;

@Service
public class PlanetServiceImpl implements PlanetService {

    public static final String SOLAR_SYSTEM = "Solar System";

    @Override
    public Flux<Planet> getPlanets() {
        return Flux.just(
                new Planet("Mercury", SOLAR_SYSTEM),
                new Planet("Venus", SOLAR_SYSTEM),
                new Planet("Earth", SOLAR_SYSTEM),
                new Planet("Mars", SOLAR_SYSTEM),
                new Planet("Jupiter", SOLAR_SYSTEM),
                new Planet("Saturn", SOLAR_SYSTEM),
                new Planet("Uranus", SOLAR_SYSTEM),
                new Planet("Neptune", SOLAR_SYSTEM));
    }

    @Override
    public Flux<Moon> getMoons() {
        return Flux.just(
                new Moon("Moon", "Earth", Year.of(0)),
                new Moon("Phobos", "Mars", Year.of(1877)),
                new Moon("Deimos", "Mars", Year.of(1877)),
                new Moon("Io", "Jupiter", Year.of(1610)),
                new Moon("Europa", "Jupiter", Year.of(1610)),
                new Moon("Ganymede", "Jupiter", Year.of(1610)),
                new Moon("Callisto", "Jupiter", Year.of(1610)),
                new Moon("Amalthea", "Jupiter", Year.of(1892)),
                new Moon("Himalia", "Jupiter", Year.of(1904)),
                new Moon("Elara", "Jupiter", Year.of(1905)),
                new Moon("Pasiphae", "Jupiter", Year.of(1908)),
                new Moon("Sinope", "Jupiter", Year.of(1914)),
                new Moon("Lysithea", "Jupiter", Year.of(1938)),
                new Moon("Carme", "Jupiter", Year.of(1938)),
                new Moon("Ananke", "Jupiter", Year.of(1951)),
                new Moon("Leda", "Jupiter", Year.of(1974)),
                new Moon("Thebe", "Jupiter", Year.of(1979)),
                new Moon("Adrastea", "Jupiter", Year.of(1979)),
                new Moon("Metis", "Jupiter", Year.of(1979)),
                new Moon("Callirrhoe", "Jupiter", Year.of(2000)),
                new Moon("Themisto", "Jupiter", Year.of(1975)),
                new Moon("Megaclite", "Jupiter", Year.of(2000)),
                new Moon("Taygete", "Jupiter", Year.of(2000)),
                new Moon("Chaldene", "Jupiter", Year.of(2000)),
                new Moon("Harpalyke", "Jupiter", Year.of(2000)),
                new Moon("Kalyke", "Jupiter", Year.of(2000)),
                new Moon("Iocaste", "Jupiter", Year.of(2000)),
                new Moon("Erinome", "Jupiter", Year.of(2000)),
                new Moon("Isonoe", "Jupiter", Year.of(2000)),
                new Moon("Praxidike", "Jupiter", Year.of(2000)),
                new Moon("Autonoe", "Jupiter", Year.of(2001)),
                new Moon("Thyone", "Jupiter", Year.of(2001)),
                new Moon("Hermippe", "Jupiter", Year.of(2001)),
                new Moon("Aitne", "Jupiter", Year.of(2001)),
                new Moon("Eurydome", "Jupiter", Year.of(2001)),
                new Moon("Euanthe", "Jupiter", Year.of(2001)),
                new Moon("Euporie", "Jupiter", Year.of(2001)),
                new Moon("Orthosie", "Jupiter", Year.of(2001)),
                new Moon("Sponde", "Jupiter", Year.of(2001)),
                new Moon("Kale", "Jupiter", Year.of(2001)),
                new Moon("Pasithee", "Jupiter", Year.of(2001)),
                new Moon("Hegemone", "Jupiter", Year.of(2003)),
                new Moon("Mneme", "Jupiter", Year.of(2003)),
                new Moon("Aoede", "Jupiter", Year.of(2003)),
                new Moon("Thelxinoe", "Jupiter", Year.of(2003)),
                new Moon("Arche", "Jupiter", Year.of(2002)),
                new Moon("Kallichore", "Jupiter", Year.of(2003)),
                new Moon("Helike", "Jupiter", Year.of(2003)),
                new Moon("Carpo", "Jupiter", Year.of(2003)),
                new Moon("Eukelade", "Jupiter", Year.of(2003)),
                new Moon("Cyllene", "Jupiter", Year.of(2003)),
                new Moon("Kore", "Jupiter", Year.of(2003)),
                new Moon("Herse", "Jupiter", Year.of(2003)),
                new Moon("S/2010 J 1", "Jupiter", Year.of(2010)),
                new Moon("S/2010 J 2", "Jupiter", Year.of(2010)),
                new Moon("Dia", "Jupiter", Year.of(2000)),
                new Moon("S/2016 J 1", "Jupiter", Year.of(2016)),
                new Moon("S/2003 J 18", "Jupiter", Year.of(2003)),
                new Moon("S/2011 J 2", "Jupiter", Year.of(2011)),
                new Moon("Eirene", "Jupiter", Year.of(2003)),
                new Moon("Philophrosyne", "Jupiter", Year.of(2003)),
                new Moon("S/2017 J 1", "Jupiter", Year.of(2017)),
                new Moon("Eupheme", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 19", "Jupiter", Year.of(2003)),
                new Moon("Valetudo", "Jupiter", Year.of(2016)),
                new Moon("S/2017 J 2", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 3", "Jupiter", Year.of(2017)),
                new Moon("Pandia", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 5", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 6", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 7", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 8", "Jupiter", Year.of(2017)),
                new Moon("S/2017 J 9", "Jupiter", Year.of(2017)),
                new Moon("Ersa", "Jupiter", Year.of(2018)),
                new Moon("S/2011 J 1", "Jupiter", Year.of(2011)),
                new Moon("S/2003 J 16", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 9", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 2", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 4", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 10", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 12", "Jupiter", Year.of(2003)),
                new Moon("S/2003 J 23", "Jupiter", Year.of(2003)),
                new Moon("Mimas", "Saturn", Year.of(1789)),
                new Moon("Enceladus", "Saturn", Year.of(1789)),
                new Moon("Tethys", "Saturn", Year.of(1684)),
                new Moon("Dione", "Saturn", Year.of(1684)),
                new Moon("Rhea", "Saturn", Year.of(1672)),
                new Moon("Titan", "Saturn", Year.of(1655)),
                new Moon("Hyperion", "Saturn", Year.of(1848)),
                new Moon("Iapetus", "Saturn", Year.of(1671)),
                new Moon("Phoebe", "Saturn", Year.of(1899)),
                new Moon("Janus", "Saturn", Year.of(1966)),
                new Moon("Epimetheus", "Saturn", Year.of(1966)),
                new Moon("Helene", "Saturn", Year.of(1980)),
                new Moon("Telesto", "Saturn", Year.of(1980)),
                new Moon("Calypso", "Saturn", Year.of(1980)),
                new Moon("Atlas", "Saturn", Year.of(1980)),
                new Moon("Prometheus", "Saturn", Year.of(1980)),
                new Moon("Pandora", "Saturn", Year.of(1980)),
                new Moon("Pan", "Saturn", Year.of(1990)),
                new Moon("Ymir", "Saturn", Year.of(2000)),
                new Moon("Paaliaq", "Saturn", Year.of(2000)),
                new Moon("Tarvos", "Saturn", Year.of(2000)),
                new Moon("Ijiraq", "Saturn", Year.of(2000)),
                new Moon("Suttungr", "Saturn", Year.of(2000)),
                new Moon("Kiviuq", "Saturn", Year.of(2000)),
                new Moon("Mundilfari", "Saturn", Year.of(2000)),
                new Moon("Albiorix", "Saturn", Year.of(2000)),
                new Moon("Skathi", "Saturn", Year.of(2000)),
                new Moon("Erriapus", "Saturn", Year.of(2000)),
                new Moon("Siarnaq", "Saturn", Year.of(2000)),
                new Moon("Thrymr", "Saturn", Year.of(2000)),
                new Moon("Narvi", "Saturn", Year.of(2003)),
                new Moon("Methone", "Saturn", Year.of(2004)),
                new Moon("Pallene", "Saturn", Year.of(2004)),
                new Moon("Polydeuces", "Saturn", Year.of(2004)),
                new Moon("Daphnis", "Saturn", Year.of(2005)),
                new Moon("Aegir", "Saturn", Year.of(2004)),
                new Moon("Bebhionn", "Saturn", Year.of(2004)),
                new Moon("Bergelmir", "Saturn", Year.of(2004)),
                new Moon("Bestla", "Saturn", Year.of(2004)),
                new Moon("Farbauti", "Saturn", Year.of(2004)),
                new Moon("Fenrir", "Saturn", Year.of(2004)),
                new Moon("Fornjot", "Saturn", Year.of(2004)),
                new Moon("Hati", "Saturn", Year.of(2004)),
                new Moon("Hyrrokkin", "Saturn", Year.of(2004)),
                new Moon("Kari", "Saturn", Year.of(2006)),
                new Moon("Loge", "Saturn", Year.of(2006)),
                new Moon("Skoll", "Saturn", Year.of(2006)),
                new Moon("Surtur", "Saturn", Year.of(2006)),
                new Moon("Anthe", "Saturn", Year.of(2007)),
                new Moon("Jarnsaxa", "Saturn", Year.of(2006)),
                new Moon("Greip", "Saturn", Year.of(2006)),
                new Moon("Tarqeq", "Saturn", Year.of(2007)),
                new Moon("S/2004 S 7", "Saturn", Year.of(2004)),
                new Moon("S/2004 S 12", "Saturn", Year.of(2004)),
                new Moon("S/2004 S 13", "Saturn", Year.of(2004)),
                new Moon("S/2004 S 17", "Saturn", Year.of(2004)),
                new Moon("S/2006 S 1", "Saturn", Year.of(2006)),
                new Moon("S/2006 S 3", "Saturn", Year.of(2006)),
                new Moon("S/2007 S 2", "Saturn", Year.of(2007)),
                new Moon("S/2007 S 3", "Saturn", Year.of(2007)),
                new Moon("S/2004 S 20", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 21", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 22", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 23", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 24", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 25", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 26", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 27", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 28", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 29", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 30", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 31", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 32", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 33", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 34", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 35", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 36", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 37", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 38", "Saturn", Year.of(2019)),
                new Moon("S/2004 S 39", "Saturn", Year.of(2019)),
                new Moon("Ariel", "Uranus", Year.of(1851)),
                new Moon("Umbriel", "Uranus", Year.of(1851)),
                new Moon("Titania", "Uranus", Year.of(1787)),
                new Moon("Oberon", "Uranus", Year.of(1787)),
                new Moon("Miranda", "Uranus", Year.of(1948)),
                new Moon("Cordelia", "Uranus", Year.of(1986)),
                new Moon("Ophelia", "Uranus", Year.of(1986)),
                new Moon("Bianca", "Uranus", Year.of(1986)),
                new Moon("Cressida", "Uranus", Year.of(1986)),
                new Moon("Desdemona", "Uranus", Year.of(1986)),
                new Moon("Juliet", "Uranus", Year.of(1986)),
                new Moon("Portia", "Uranus", Year.of(1986)),
                new Moon("Rosalind", "Uranus", Year.of(1986)),
                new Moon("Belinda", "Uranus", Year.of(1986)),
                new Moon("Puck", "Uranus", Year.of(1985)),
                new Moon("Caliban", "Uranus", Year.of(1997)),
                new Moon("Sycorax", "Uranus", Year.of(1997)),
                new Moon("Prospero", "Uranus", Year.of(1999)),
                new Moon("Setebos", "Uranus", Year.of(1999)),
                new Moon("Stephano", "Uranus", Year.of(1999)),
                new Moon("Trinculo", "Uranus", Year.of(2001)),
                new Moon("Francisco", "Uranus", Year.of(2001)),
                new Moon("Margaret", "Uranus", Year.of(2003)),
                new Moon("Ferdinand", "Uranus", Year.of(2001)),
                new Moon("Perdita", "Uranus", Year.of(1999)),
                new Moon("Mab", "Uranus", Year.of(2003)),
                new Moon("Cupid", "Uranus", Year.of(2003)),
                new Moon("Triton", "Neptune", Year.of(1846)),
                new Moon("Nereid", "Neptune", Year.of(1949)),
                new Moon("Naiad", "Neptune", Year.of(1989)),
                new Moon("Thalassa", "Neptune", Year.of(1989)),
                new Moon("Despina", "Neptune", Year.of(1989)),
                new Moon("Galatea", "Neptune", Year.of(1989)),
                new Moon("Larissa", "Neptune", Year.of(1981)),
                new Moon("Proteus", "Neptune", Year.of(1989)),
                new Moon("Halimede", "Neptune", Year.of(2002)),
                new Moon("Psamathe", "Neptune", Year.of(2003)),
                new Moon("Sao", "Neptune", Year.of(2002)),
                new Moon("Laomedeia", "Neptune", Year.of(2002)),
                new Moon("Neso", "Neptune", Year.of(2002)),
                new Moon("Hippocamp", "Neptune", Year.of(2013)),
                new Moon("Charon", "Pluto", Year.of(1978)),
                new Moon("Nix", "Pluto", Year.of(2005)),
                new Moon("Hydra", "Pluto", Year.of(2005)),
                new Moon("Kerberos", "Pluto", Year.of(2011)),
                new Moon("Styx", "Pluto", Year.of(2012)));
    }
}
