package seminarski
import scalafx.scene.canvas.GraphicsContext
import scala.collection.mutable.ArrayBuffer
import scalafx.scene.image.Image
import java.io.File
import scalafx.scene.media.MediaPlayer
import scalafx.scene.media.Media
import javafx.util.Duration

/**
  * Created by szmasters on 3/27/2016.
  */
object CrtanjeNaCanvas {
  val media = new Media(new File("src"+File.separator+"muzika"+File.separator+"Mozart-String Serenade no. 13 in G, K. 525 , Mov. 2.mp3").toURI().toString())
  val mediaPlayer = new MediaPlayer(media)
  mediaPlayer.setOnEndOfMedia(new Runnable(){
        def run:Unit={
          mediaPlayer.seek(Duration.ZERO)
        }
      })
  var oblaci = ArrayBuffer[Oblak]()
  var knjige = new ArrayBuffer[Knjiga]
  var munje = new ArrayBuffer[Munja]
  def draw(gc:GraphicsContext){
    if(oblaci.forall { o => o.x == -100 }){
      SeminarskiGlavna.prviNivo = false
      SeminarskiGlavna.timer.stop()
      Uvod1.mediaPlayer.stop()
      Uvod2.mediaPlayer.play()
      oblaci.foreach { o => o.radi = false }
      knjige.foreach { k => k.vanEkrana = true;k.y = 1000 }
      munje.foreach { m => m.radi = false }
      SeminarskiGlavna.stejdz.scene = SeminarskiGlavna.stejdz.uvod2
      SeminarskiGlavna.sad = System.nanoTime()
      SeminarskiGlavna.drugi2.start()
      return
    }
    Sova.draw(gc)
    knjige.filter { k => !k.vanEkrana }.foreach { k => k.draw(gc) }
    oblaci.filter { o => o.x != -100 }.foreach { o => {
      if(o.energija<=0)
        o.slika = new Image("slike"+File.separator+"pukoOblak.png") 
      o.draw(gc)
      }
    }
    munje.filter { m => !m.vanEkrana }.foreach { m => m.draw(gc) }
    
    if(Sova.gameover){
       oblaci.foreach { o => o.radi = false }
       munje.foreach { m => m.radi = false }
       SeminarskiGlavna.timer.stop()
       Uvod1.mediaPlayer.stop()
       mediaPlayer.play()
       SeminarskiGlavna.stejdz.scene = SeminarskiGlavna.stejdz.izgubio
    }
  }
  def inicijalizuj(){
    var ob = for(i<-1 to 12) yield new Oblak 
    oblaci = ob.to[ArrayBuffer]
    var m = for(i<-1 to 200) yield new Munja
    munje = m.to[ArrayBuffer]
  }
}
