#include <iostream>
#include <cstdlib>
#include <algorithm>
#include <set>
#include <ctime>
#include <string>
#include <vector>
#include "AVL_tree.hpp"
 
using namespace std;
using namespace avl_stablo;
//CPP kod implementacija balansirajucih AVL-stabala

//Demonstracija funkcionalnog pristupa; Pretraga kombinacijom iteratora i lambda funkcija
template <typename Collection,typename Condition>
bool Trazi(Collection K,Condition U) {
   auto Trazi = std::find_if(K.begin(),K.end(),U);
   return Trazi != K.end();
}

int main(){
	auto stampaj = [](const string& message){std::cout << message << std::endl; }; //Analogon print u C
  
	//Test primer 1:
	AVL_stablo<int> my_avl;
	for(int i=10; i>=0; i--)
	  my_avl.Upisi(i);
	stampaj("Broj elemenata unetog stabla: 11;   Visina: "+to_string(my_avl.VisinaStabla()));
	stampaj("Levo-Koren-Desno");
	my_avl.StampajInOrder();
	stampaj("Koren-Levo-Desno");
	my_avl.StampajPreOrder();
	stampaj("Levo-Koren-Desno");
	my_avl.StampajPostOrder();
		
	//Test primer 2:
	//Testiranje rada programa na "relativno velikom" ulazu	
	AVL_stablo<double> my_avl1;
	double niz[1000000];
	for(int i=0; i<sizeof(niz)/sizeof(niz[0]); i++)
	    niz[i]=i;
	random_shuffle(begin(niz), end(niz));
	for(int i=0; i<sizeof(niz)/sizeof(niz[0]); i++)
	  my_avl1.Upisi(niz[i]);
	stampaj("Broj elemenata unetog stabla: 1 000 000;   Visina: "+to_string(my_avl1.VisinaStabla()));
	
	//Test primer 3:
	//AVL_stablo<int> my_avl2;
	//int niz2[1000000000];
	//for(int i=0; i<sizeof(niz2)/sizeof(niz2[0]); i++)
	//    niz2[i]=i;
	//random_shuffle(begin(niz2), end(niz2));
	//for(int i=0; i<sizeof(niz2)/sizeof(niz2[0]); i++)
	//  my_avl2.Upisi(niz2[i]);
	//stampaj("Broj elemenata unetog stabla: 1 000 000 000;   Visina: "+to_string(my_avl2.VisinaStabla()));

	int t1=clock();
	stampaj("Pretraga AVL stabla: ");
	std::cout << "Trazim broj 7 u stablu = (Funkcija klase AVL_stablo)"<< std::endl;
	if(my_avl.Trazi(7))
		std::cout<<"Broj 7 prisutan u stablu."<<std::endl;
	else	
		std::cout<<"Broj 7 NIJE prisutan u stablu."<<std::endl;
	std::cout << "Trazim broj -7 u stablu = (Funkcija klase AVL_stablo)"<< std::endl;
	if(my_avl.Trazi(-7))
		std::cout<<"Broj -7 prisutan u stablu."<<std::endl;
	else	
		std::cout<<"Broj -7 NIJE prisutan u stablu."<<std::endl;
	t1=clock()-t1;
	std::cout<<"Vreme potreno AVL stablu sa 1 000 000 elemenata: "<<t1<<std::endl<<std::endl;
	std::vector<int> V;
	for(int i=0; i<1000000; i++)
		V.push_back(niz[i]);

	int t2=clock();
	stampaj("Pretraga vectora (sablon funkcija u kombinaciji sa lambda programiranjem): ");
	std::cout << "Trazim broj 7 u vektoru:"<< std::endl;
	if(Trazi(V, [] (int v){ return v==7;}))
		std::cout<<"Broj 7 prisutan u vektoru."<<std::endl;
	else	
		std::cout<<"Broj 7 NIJE prisutan u vektoru."<<std::endl;
	std::cout << "Trazim broj -7 u vektoru:"<< std::endl;
	if(Trazi(V, [] (int v){ return v==-7;}))
		std::cout<<"Broj -7 prisutan u vektoru."<<std::endl;
	else	
		std::cout<<"Broj -7 NIJE prisutan u vektoru."<<std::endl;
	t2=clock()-t2;
	std::cout<<"Vreme potreno vektoru sa 1 000 000 elemenata: "<<t2<<std::endl<<std::endl;	

	return 0;
}

