#ifndef AVL_TREE_H
#define AVL_TREE_H

#define AVL_LEVI 0
#define AVL_DESNI 1

#include <iostream>
#include <algorithm>
#include <vector>

using std::vector;

namespace avl_stablo{
	
  template<typename T>
  class AVL_cvor{
  public:
  	
  	static int Obrni(int w); //menja nulu i jedinicu
    
    AVL_cvor() : podatak(T()), visina(1) {}
    AVL_cvor(const T& _podatak) : podatak(_podatak), visina(1) {potomak[AVL_LEVI] = potomak[AVL_DESNI] = NULL;}
    AVL_cvor(const AVL_cvor<T>& t) : podatak(t.podatak), visina(t.visina), balans(t.balans) {potomak[AVL_LEVI] = potomak[AVL_DESNI] = NULL;}
    
    void SetPodatak(const T& vrednost);
    const T& GetPodatak() const;
    
    void SetPotomak(int idx, AVL_cvor<T>* t);
    AVL_cvor<T>* GetPotomak(int idx) const;
    
    int GetVisina() const;
    int GetBalans() const;
    bool Balansiran() const;
    
  private:
    T podatak;
    AVL_cvor* potomak[2];
    int visina;
    int balans;
    
    void Azuriraj();
  };
  
  template<typename T>
  void AVL_cvor<T>::SetPodatak(const T& vrednost) {
    podatak = vrednost;
  }
  
  template<typename T>
  const T& AVL_cvor<T>::GetPodatak() const {
    return podatak;
  }
  
  template<typename T>
  void AVL_cvor<T>::SetPotomak(int idx, AVL_cvor<T>* t) {
    potomak[idx] = t;
    Azuriraj();
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_cvor<T>::GetPotomak(int idx) const {
    return potomak[idx];
  }
  
  template<typename T>
  int AVL_cvor<T>::GetVisina() const {
  	return visina;
  }
  
  template<typename T>
  int AVL_cvor<T>::GetBalans() const {
  	return balans;
  }
  
  template<typename T>
  bool AVL_cvor<T>::Balansiran() const {
  	return balans <= 1 && balans >= -1;
  }
  
  template<typename T>
  void AVL_cvor<T>::Azuriraj() {
	if(potomak[AVL_LEVI] == NULL && potomak[AVL_DESNI] == NULL) {
		visina = 1;
		balans = 0;
	}
	else if(potomak[AVL_LEVI] == NULL) {
		visina = potomak[AVL_DESNI]->visina + 1;
		balans = visina - 1;
	}
	else if(potomak[AVL_DESNI] == NULL) {
		visina = potomak[AVL_LEVI]->visina + 1;
		balans = 1 - visina;
	}
	else {
		visina = std::max(potomak[AVL_LEVI]->visina, potomak[AVL_DESNI]->visina) + 1;
		balans = potomak[AVL_DESNI]->visina - potomak[AVL_LEVI]->visina;
	}
  }
  
  template<typename T>
  int AVL_cvor<T>::Obrni(int w) {
  	return ~w & 1;
  }
  
  
  
  //----------------------------------------------------------------------------------------------- 



  template<typename T>
  class AVL_iterator{
  public:
  	AVL_iterator() : stack(vector<AVL_cvor<T>*>()) {}
    AVL_iterator(vector<AVL_cvor<T>*> _stack) : stack(_stack) {}
    AVL_iterator<T>& operator++();
    bool operator==(const AVL_iterator<T>& t) const;
    bool operator!=(const AVL_iterator<T>& t) const;
    T operator*() const;
    
  private:
    vector<AVL_cvor<T>*> stack; //trenutni element je poslednji element steka
  };
  
  template<typename T>
  bool AVL_iterator<T>::operator==(const AVL_iterator<T>& t) const {
  	if(stack.size() != t.stack.size())
  		return false;
  	return stack.empty() || stack.back() == t.stack.back();
  }
  
  template<typename T>
  bool AVL_iterator<T>::operator!=(const AVL_iterator<T>& t) const {
  	return !operator==(t);
  }
  
  template<typename T>
  AVL_iterator<T>& AVL_iterator<T>::operator++() {
  	if(stack.empty())
  		return *this;
  	if(stack.back()->GetPotomak(AVL_DESNI) != NULL) {
  		stack.push_back(stack.back()->GetPotomak(AVL_DESNI));
  		while(stack.back()->GetPotomak(AVL_LEVI) != NULL)
  			stack.push_back(stack.back()->GetPotomak(AVL_LEVI));
  	} else {
  		T v = stack.back()->GetPodatak();
  		while(!stack.empty() && stack.back()->GetPodatak() <= v)
  			stack.pop_back();
  	}
  	return *this;
  }
  
  template<typename T>
  T AVL_iterator<T>::operator*() const {
  	if(stack.empty())
  		return T();
  	return stack.back()->GetPodatak();
  }



  //-----------------------------------------------------------------------------------------------



  template<typename T>
  class AVL_stablo{
  public:
    
    AVL_stablo() : koren(NULL) {}
    AVL_stablo(const AVL_stablo<T>& t); //copy construktor
    
    ~AVL_stablo();

    void Upisi(const T& vrednost);                   //Balansiranja se vrse prilikom upisivanja
    void Obrisi(const T& vrednost);                  //Balansiranja se vrse i prilikom brisanja
    bool Trazi(const T& vrednost) const;
    
    void StampajPreOrder () const; // Koren, Levo, Desno
    void StampajInOrder  () const; // Levo, Koren, Desno
    void StampajPostOrder() const; // Levo, Desno, Koren
    
    void Isprazni();
    int VisinaStabla() const;
    
    //Iterator
    AVL_iterator<T> begin() const;
    AVL_iterator<T> end  () const;

  private:
    AVL_cvor<T>* koren;
    
    AVL_cvor<T>* Upisi(const T& vrednost, AVL_cvor<T>* t);                   //Balansiranja se vrse prilikom upisivanja
    AVL_cvor<T>* Obrisi(const T& vrednost, AVL_cvor<T>* t);                  //Balansiranja se vrse i prilikom brisanja
    bool Trazi(const T& vrednost, AVL_cvor<T>* t) const;
    
    void StampajPreOrder (AVL_cvor<T>* root) const; // Koren, Levo, Desno
    void StampajInOrder  (AVL_cvor<T>* root) const; // Levo, Koren, Desno
    void StampajPostOrder(AVL_cvor<T>* root) const; // Levo, Desno, Koren

	AVL_cvor<T>* Rotacija1(AVL_cvor<T>* t, int w); //w = AVL_levi ili AVL_desni
	AVL_cvor<T>* Rotacija2(AVL_cvor<T>* t, int w);
	AVL_cvor<T>* Najlevlji(AVL_cvor<T>* t) const; //ide levo dok moze, za brisanje
	AVL_cvor<T>* Balansiraj(AVL_cvor<T>* t);
	
	void Isprazni(AVL_cvor<T>* t);
	AVL_cvor<T>* Kopiraj(AVL_cvor<T>* t);
  };
  
  template<typename T>
  AVL_stablo<T>::AVL_stablo(const AVL_stablo<T>& t) {
  	koren = Kopiraj(t.koren);
  }
  
  template<typename T>
  AVL_stablo<T>::~AVL_stablo() {
  	Isprazni(koren);
  }
  
  template<typename T>
  void AVL_stablo<T>::Upisi(const T& vrednost) {
  	koren = Upisi(vrednost, koren);
  }
  
  template<typename T>
  void AVL_stablo<T>::Obrisi(const T& vrednost) {
  	koren = Obrisi(vrednost, koren);
  }
  
  template<typename T>
  void AVL_stablo<T>::Isprazni() {
  	Isprazni(koren);
  }
  
  template<typename T>
  bool AVL_stablo<T>::Trazi(const T& vrednost) const {
  	return Trazi(vrednost, koren);
  }
  
  template<typename T>
  bool AVL_stablo<T>::Trazi(const T& vrednost, AVL_cvor<T>* t) const {
  	if(t == NULL)
  		return false;
  	if(vrednost < t->GetPodatak())
  		return Trazi(vrednost, t->GetPotomak(AVL_LEVI));
  	if(vrednost > t->GetPodatak())
  		return Trazi(vrednost, t->GetPotomak(AVL_DESNI));
  	return true;
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Rotacija1(AVL_cvor<T>* t, int w) {
  	int f = AVL_cvor<T>::Obrni(w);
	AVL_cvor<T>* b = t->GetPotomak(w);
	t->SetPotomak(w, t->GetPotomak(w)->GetPotomak(f));
	b->SetPotomak(f, t);
	return b;
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Rotacija2(AVL_cvor<T>* t, int w) {
  	int f = AVL_cvor<T>::Obrni(w);
	AVL_cvor<T>* b = t->GetPotomak(w);
	AVL_cvor<T>* d = b->GetPotomak(f);
	b->SetPotomak(f, d->GetPotomak(w));
	t->SetPotomak(w, d->GetPotomak(f));
	d->SetPotomak(w, b);
	d->SetPotomak(f, t);
	return d;
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Upisi(const T& vrednost, AVL_cvor<T>* t) {
  	if(t == NULL)
		return new AVL_cvor<T>(vrednost);
	if(t->GetPodatak() == vrednost)
		return t;
	int wc = vrednost > t->GetPodatak();
	t->SetPotomak(wc, Upisi(vrednost, t->GetPotomak(wc)));
	return Balansiraj(t);
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Obrisi(const T& vrednost, AVL_cvor<T>* t) {
  	if(t == NULL)
		return t;
	if(vrednost != t->GetPodatak()) {
		int wc = vrednost > t->getPodatak();
		t->SetPotomak(wc, Obrisi(vrednost, t->GetPotomak(wc)));
		return Balansiraj(t);
	}
	int wc = -1;
	if(t->GetPotomak(AVL_LEVI) == NULL) wc = AVL_DESNI;
	if(t->GetPotomak(AVL_DESNI) == NULL) wc = AVL_LEVI;
	if(wc != -1) {
		AVL_cvor<T>* ret = t->GetPotomak(wc);
		delete t;
		return ret;
	}
	AVL_cvor<T>* s = Najlevlji(t->GetPotomak(AVL_DESNI));
	T tmp = s->GetPodatak();
	s->SetPodatak(t->GetPodatak());
	t->SetPodatak(tmp);
	t->SetPotomak(AVL_DESNI, Obrisi(vrednost, t->GetPotomak(AVL_DESNI)));
	return Balansiraj(t);
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Najlevlji(AVL_cvor<T>* t) const {
  	if(t->GetPotomak(AVL_LEVI) == NULL)
		return t;
	return Najlevlji(t->GetPotomak(AVL_LEVI));
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Balansiraj(AVL_cvor<T>* t) {
  	if(!t->Balansiran()) {
		int w = t->GetBalans() > 0;
		if(t->GetPotomak(w)->GetBalans() * t->GetBalans() > 0)
			t = Rotacija1(t, w);
		else
			t = Rotacija2(t, w);
	}
	return t;
  }
  
  template<typename T>
  void AVL_stablo<T>::Isprazni(AVL_cvor<T>* t) {
  	if(t == NULL)
  		return;
  	Isprazni(t->GetPotomak(AVL_LEVI));
  	Isprazni(t->GetPotomak(AVL_DESNI));
  	delete t;
  }
  
  template<typename T>
  AVL_cvor<T>* AVL_stablo<T>::Kopiraj(AVL_cvor<T>* t) {
  	if(t == NULL)
  		return NULL;
  	AVL_cvor<T>* novi = new AVL_cvor<T>(*t);
  	novi->SetPotomak(AVL_LEVI, Kopiraj(t->GetPotomak(AVL_LEVI)));
  	novi->SetPotomak(AVL_DESNI, Kopiraj(t->GetPotomak(AVL_DESNI)));
  	return novi;
  }
  
  template<typename T>
  int AVL_stablo<T>::VisinaStabla() const{
    return koren->GetVisina();
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajInOrder() const {
  	StampajInOrder(koren);
  	std::cout << std::endl;
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajInOrder(AVL_cvor<T>* t) const {
  	if(t == NULL)
		return;
	StampajInOrder(t->GetPotomak(AVL_LEVI));
	std::cout << t->GetPodatak() << " ";
	StampajInOrder(t->GetPotomak(AVL_DESNI));
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajPreOrder() const {
  	StampajPreOrder(koren);
  	std::cout << std::endl;
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajPreOrder(AVL_cvor<T>* t) const {
  	if(t == NULL)
		return;
	std::cout << t->GetPodatak() << " ";
	StampajPreOrder(t->GetPotomak(AVL_LEVI));
	StampajPreOrder(t->GetPotomak(AVL_DESNI));
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajPostOrder() const {
  	StampajPostOrder(koren);
  	std::cout << std::endl;
  }
  
  template<typename T>
  void AVL_stablo<T>::StampajPostOrder(AVL_cvor<T>* t) const {
  	if(t == NULL)
		return;
	StampajPostOrder(t->GetPotomak(AVL_LEVI));
	StampajPostOrder(t->GetPotomak(AVL_DESNI));
	std::cout << t->GetPodatak() << " ";
  }
  
  template<typename T>
  AVL_iterator<T> AVL_stablo<T>::begin() const {
  	vector<AVL_cvor<T>*> stack;
  	stack.push_back(koren);
  	while(stack.back()->GetPotomak(AVL_LEVI) != NULL)
  		stack.push_back(stack.back()->GetPotomak(AVL_LEVI));
  	return AVL_iterator<T>(stack);
  }
  
  template <typename T>
  AVL_iterator<T> AVL_stablo<T>::end() const {
  	return AVL_iterator<T>();
  }
  
}

#endif
