/*
 * Decompiled with CFR 0.152.
 */
package com.pmf.kviz.servis;

import com.pmf.kviz.forme.GreskaDijalog$;
import com.pmf.kviz.forme.InfoDijalog$;
import com.pmf.kviz.model.Pitanje;
import com.pmf.kviz.servis.FajlServis$;
import com.pmf.kviz.vo.Konstante$;
import de.nixosoft.jlr.JLRGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class PitanjeServis$ {
    public static PitanjeServis$ MODULE$;
    private final Logger logger;
    private Map<String, scala.collection.mutable.Set<Pitanje>> pitanjaPoOblastima;

    static {
        new PitanjeServis$();
    }

    public Logger logger() {
        return this.logger;
    }

    private Map<String, scala.collection.mutable.Set<Pitanje>> pitanjaPoOblastima() {
        return this.pitanjaPoOblastima;
    }

    private void pitanjaPoOblastima_$eq(Map<String, scala.collection.mutable.Set<Pitanje>> x$1) {
        this.pitanjaPoOblastima = x$1;
    }

    public Map<String, scala.collection.mutable.Set<Pitanje>> ucitajSvaPitanja() {
        this.logger().debug("Ucitavam oblasti");
        List<String> oblasti = FajlServis$.MODULE$.dohvatiNazivePostojecihDokumenata(Konstante$.MODULE$.repozitorijumPitanja());
        this.logger().debug("Ucitavam postojeca pitanja");
        this.pitanjaPoOblastima_$eq((Map)Map$.MODULE$.apply(oblasti.map((Function1<String, Tuple2> & Serializable & scala.Serializable)oblast -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(oblast), FajlServis$.MODULE$.ucitajXMLDokument(Konstante$.MODULE$.repozitorijumPitanja().concat("/").concat((String)oblast).concat(".xml"))), List$.MODULE$.canBuildFrom())));
        return this.pitanjaPoOblastima();
    }

    public Set<String> dohvatiSveOblasti() {
        this.logger().debug("Dohvatam postojece oblasti");
        return this.pitanjaPoOblastima().keySet();
    }

    public List<Pitanje> ucitajNovaPitanjaIzFajla(File fajl) {
        this.logger().debug("Ucitavam nova pitanja");
        return FajlServis$.MODULE$.ucitajXMLDokument(fajl).toList();
    }

    public void dodajNovaPitanja(List<Pitanje> novaPitanja) {
        this.logger().debug("Rasporedjujem nova pitanja po oblastima");
        novaPitanja.foreach((Function1<Pitanje, Option> & Serializable & scala.Serializable)pitanje -> {
            String oblast = pitanje.oblast();
            scala.collection.mutable.Set pitanja = (scala.collection.mutable.Set)this.pitanjaPoOblastima().getOrElse(oblast, (Function0<scala.collection.mutable.Set> & Serializable & scala.Serializable)() -> (scala.collection.mutable.Set)Set$.MODULE$.apply(Nil$.MODULE$));
            pitanja.add(pitanje);
            return this.pitanjaPoOblastima().put(oblast, pitanja);
        });
        this.azurirajFajloveSaPitanjima();
    }

    private void azurirajFajloveSaPitanjima() {
        this.logger().debug("Azuriram postojece i pravim nove fajlove po oblastima sa pitanjima");
        this.pitanjaPoOblastima().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)par -> {
            FajlServis$.MODULE$.ispisiXMLDokument(Konstante$.MODULE$.repozitorijumPitanja().concat("/").concat((String)par._1()).concat(".xml"), ((TraversableOnce)par._2()).toList());
            return BoxedUnit.UNIT;
        });
    }

    public List<Pitanje> generisiSadrzajKviza(Option<Object> tezina, scala.collection.immutable.Map<String, Object> konfiguracijaOblasti) {
        List list;
        if (tezina.isEmpty() && konfiguracijaOblasti.isEmpty()) {
            this.logger().debug("Neuspesno generisanje kviza. Nije zadata ni tezina niti konfiguracija oblasti");
            list = Nil$.MODULE$;
        } else if (konfiguracijaOblasti.isEmpty()) {
            this.logger().debug("Generisem kviz bez izabranih oblasti sa zadatom tezinom");
            IntRef trenutnaTezina = IntRef.create(0);
            List svaPitanjaSortirano = (List)((SeqLike)((Object)((TraversableOnce)this.pitanjaPoOblastima().map((Function1<Tuple2, scala.collection.mutable.Set> & Serializable & scala.Serializable)par -> (scala.collection.mutable.Set)par._2(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList().flatten((Function1)Predef$.MODULE$.$conforms()))).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            List sadrzajKviza = (List)((GenericTraversableTemplate)((TraversableLike)svaPitanjaSortirano.map((Function1<Pitanje, Option> & Serializable & scala.Serializable)pitanje -> {
                Option option;
                if (trenutnaTezina$1.elem + pitanje.tezina() <= BoxesRunTime.unboxToInt(tezina.get())) {
                    trenutnaTezina$1.elem += pitanje.tezina();
                    option = new Some<Pitanje>((Pitanje)pitanje);
                } else {
                    option = None$.MODULE$;
                }
                return option;
            }, List$.MODULE$.canBuildFrom())).filter((Function1<Option, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isDefined()))).flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            if (!sadrzajKviza.isEmpty()) {
                sadrzajKviza.foreach((Function1<Pitanje, Object> & Serializable & scala.Serializable)pitanje -> {
                    this.azurirajBrojPonavaljanja(pitanje);
                    return BoxedUnit.UNIT;
                });
                this.azurirajFajloveSaPitanjima();
                this.logger().debug("Kviz bez izabranih oblasti sa zadatom tezinom uspesno generisan");
                list = sadrzajKviza;
            } else {
                this.logger().debug("Neuspesno generisanje kviza sa zadatom tezinom.");
                list = Nil$.MODULE$;
            }
        } else {
            this.logger().debug("Generisem kviz sa izabranim oblastima");
            IntRef trenutnaTezina = IntRef.create(0);
            scala.collection.immutable.Map pitanjaPoOblastimaSortirano = ((TraversableOnce)this.pitanjaPoOblastima().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)par -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(par._1()), ((TraversableOnce)par._2()).toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List sadrzajKviza = (List)((TraversableOnce)konfiguracijaOblasti.map((Function1<Tuple2, List> & Serializable & scala.Serializable)par -> {
                void var3_3;
                Object pitanjaPoIzabranojOblasti = ((List)pitanjaPoOblastimaSortirano.getOrElse(par._1(), (Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$)).take(par._2$mcI$sp());
                int tezinaPitanjaPoIzabranojOblasti = BoxesRunTime.unboxToInt(((TraversableOnce)((List)pitanjaPoIzabranojOblasti).map((Function1<Pitanje, Object> & Serializable & scala.Serializable)pitanje -> BoxesRunTime.boxToInteger(pitanje.tezina()), List$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
                trenutnaTezina$2.elem += tezinaPitanjaPoIzabranojOblasti;
                return var3_3;
            }, Iterable$.MODULE$.canBuildFrom())).toList().flatten((Function1)Predef$.MODULE$.$conforms());
            if (!sadrzajKviza.isEmpty()) {
                sadrzajKviza.foreach((Function1<Pitanje, Object> & Serializable & scala.Serializable)pitanje -> {
                    this.azurirajBrojPonavaljanja(pitanje);
                    return BoxedUnit.UNIT;
                });
                this.azurirajFajloveSaPitanjima();
                this.logger().debug("Kviz uspesno generisan");
                list = sadrzajKviza;
            } else {
                this.logger().debug("Neuspesno generisanje kviza sa izabranim oblastima i zadatom tezinom.");
                list = Nil$.MODULE$;
            }
        }
        return list;
    }

    private void azurirajBrojPonavaljanja(Pitanje pitanje) {
        ((IterableLike)this.pitanjaPoOblastima().getOrElse(pitanje.oblast(), (Function0<scala.collection.mutable.Set> & Serializable & scala.Serializable)() -> (scala.collection.mutable.Set)Set$.MODULE$.apply(Nil$.MODULE$))).foreach((Function1<Pitanje, Object> & Serializable & scala.Serializable)pitanjeIzOblasti -> {
            PitanjeServis$.$anonfun$azurirajBrojPonavaljanja$2(pitanje, pitanjeIzOblasti);
            return BoxedUnit.UNIT;
        });
    }

    public void generisiKvizFajlove(List<Pitanje> pitanja, boolean ukljuciOdgovore) {
        block0: {
            String generisanoImeKviza;
            block1: {
                generisanoImeKviza = "kviz_".concat(((Object)BoxesRunTime.boxToLong(System.currentTimeMillis())).toString());
                if (!this.generisiFajlove(generisanoImeKviza, pitanja, false)) break block0;
                if (ukljuciOdgovore) break block1;
                InfoDijalog$.MODULE$.prikaziInfo("Uspesno generisani kviz fajlovi sa nazivom: ".concat(generisanoImeKviza));
                break block0;
            }
            if (!this.generisiFajlove(generisanoImeKviza, pitanja, true)) break block0;
            InfoDijalog$.MODULE$.prikaziInfo("Uspesno generisani kviz i odgovor fajlovi sa nazivom: ".concat(generisanoImeKviza));
        }
    }

    private boolean generisiFajlove(String generisanoImeKviza, List<Pitanje> pitanja, boolean ukljuciOdgovore) {
        boolean bl;
        String imeKviza = ukljuciOdgovore ? generisanoImeKviza.concat("_odgovori") : generisanoImeKviza;
        Option<String> putanjaDirektorijuma = this.napraviDirektorijum(imeKviza);
        if (putanjaDirektorijuma.isDefined()) {
            String latexSadrzaj = this.generisiLatexSadrzaj(pitanja, ukljuciOdgovore);
            bl = this.generisiLatexKvizFajl(putanjaDirektorijuma.get(), imeKviza, latexSadrzaj) ? this.generisiPdfKvizFajl(putanjaDirektorijuma.get(), imeKviza) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private Option<String> napraviDirektorijum(String imeKviza) {
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0<String> & Serializable & scala.Serializable)() -> {
            void var1_1;
            String putanjaDirektorijuma = Konstante$.MODULE$.kvizovi().concat("/").concat(imeKviza).concat(".pdf");
            File direktorijum = new File(putanjaDirektorijuma);
            direktorijum.mkdir();
            return var1_1;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String putanjaDirektorijuma = (String)success.value();
            this.logger().debug("Direktorijum kviza uspesno generisan. Putanja do direktorijuma: {}", new Object[]{putanjaDirektorijuma});
            option = new Some<String>(putanjaDirektorijuma);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            ex.printStackTrace();
            GreskaDijalog$.MODULE$.prikaziGresku("Greska prilikom generisanja direktorijuma za kviz.", ex.getMessage());
            option = None$.MODULE$;
        } else {
            throw new MatchError(try_);
        }
        return option;
    }

    private String generisiLatexSadrzaj(List<Pitanje> pitanja, boolean ukljuciOdgovore) {
        StringBuilder latexSadrzaj = new StringBuilder();
        latexSadrzaj.$plus$plus$eq("\\documentclass[12pt]{article}\n");
        latexSadrzaj.$plus$plus$eq("\\usepackage{amsmath}\n");
        latexSadrzaj.$plus$plus$eq("\\title{\\vspace{-4cm}Kviz}\n");
        latexSadrzaj.$plus$plus$eq("\\date{}");
        latexSadrzaj.$plus$plus$eq("\\usepackage[parfill]{parskip}");
        latexSadrzaj.$plus$plus$eq("\\begin{document}\n");
        latexSadrzaj.$plus$plus$eq("\\maketitle\n");
        IntRef i = IntRef.create(1);
        pitanja.foreach((Function1<Pitanje, Object> & Serializable & scala.Serializable)pitanje -> {
            PitanjeServis$.$anonfun$generisiLatexSadrzaj$1(ukljuciOdgovore, latexSadrzaj, i, pitanje);
            return BoxedUnit.UNIT;
        });
        latexSadrzaj.$plus$plus$eq("\\end{document}\n");
        return latexSadrzaj.toString();
    }

    private boolean generisiLatexKvizFajl(String putanjaDirektorijuma, String imeKviza, String latexSadrzaj) {
        boolean bl;
        Try try_;
        String imeLatexKviza = imeKviza.concat(".tex");
        ObjectRef<Object> pw = ObjectRef.create(null);
        Try generisanjeLatexa = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> {
            pw$1.elem = new PrintWriter(new File(putanjaDirektorijuma.concat("/").concat(imeLatexKviza)));
            ((PrintWriter)pw$1.elem).write(latexSadrzaj);
        });
        if ((PrintWriter)pw.elem != null) {
            ((PrintWriter)pw.elem).close();
        }
        if ((try_ = generisanjeLatexa) instanceof Success) {
            this.logger().debug("Latex kviz uspesno generisan. Ime fajla: {}", new Object[]{imeLatexKviza});
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            ex.printStackTrace();
            GreskaDijalog$.MODULE$.prikaziGresku("Greska prilikom generisanja kviza u latex formatu.", ex.getMessage());
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    private boolean generisiPdfKvizFajl(String putanjaDirektorijuma, String imeKviza) {
        boolean bl;
        JLRGenerator pdfGenerator;
        String imeLatexKviza;
        String imePdfKviza = imeKviza.concat(".pdf");
        Try try_ = Try$.MODULE$.apply(() -> PitanjeServis$.$anonfun$generisiPdfKvizFajl$1(putanjaDirektorijuma, imePdfKviza, imeLatexKviza = imeKviza.concat(".tex"), pdfGenerator = new JLRGenerator()));
        if (try_ instanceof Success) {
            this.logger().debug("PDF kviz uspesno generisan. Ime fajla: {}", new Object[]{imePdfKviza});
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            ex.printStackTrace();
            GreskaDijalog$.MODULE$.prikaziGresku("Greska prilikom generisanja kviza u PDF formatu.", ex.getMessage());
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$azurirajBrojPonavaljanja$2(Pitanje pitanje$1, Pitanje pitanjeIzOblasti) {
        block0: {
            Pitanje pitanje = pitanje$1;
            Pitanje pitanje2 = pitanjeIzOblasti;
            if (pitanje != null ? !((Object)pitanje).equals(pitanje2) : pitanje2 != null) break block0;
            pitanjeIzOblasti.inkrementirajBrojPonavljanja();
        }
    }

    public static final /* synthetic */ void $anonfun$generisiLatexSadrzaj$1(boolean ukljuciOdgovore$1, StringBuilder latexSadrzaj$1, IntRef i$1, Pitanje pitanje) {
        latexSadrzaj$1.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger(i$1.elem)).toString().concat(".").concat("[").concat(((Object)BoxesRunTime.boxToInteger(pitanje.tezina())).toString()).concat("] - "));
        latexSadrzaj$1.$plus$plus$eq(pitanje.postavka() + "\n");
        latexSadrzaj$1.$plus$plus$eq("\\newline\n");
        Serializable serializable = ukljuciOdgovore$1 ? latexSadrzaj$1.$plus$plus$eq(pitanje.odgovor() + "\n\n") : BoxedUnit.UNIT;
        latexSadrzaj$1.$plus$plus$eq("\\newline\n");
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$generisiPdfKvizFajl$1(String putanjaDirektorijuma$2, String imePdfKviza$1, String imeLatexKviza$2, JLRGenerator pdfGenerator$1) {
        File latexFajl = new File(putanjaDirektorijuma$2.concat("/").concat(imeLatexKviza$2));
        File pdfFajl = new File(Konstante$.MODULE$.kvizovi().concat("/").concat(imePdfKviza$1));
        File privremeniDirektorijum = new File(Konstante$.MODULE$.kvizovi());
        pdfGenerator$1.generate(latexFajl, pdfFajl, privremeniDirektorijum);
        if (pdfGenerator$1.getPDF() == null) {
            throw new RuntimeException(pdfGenerator$1.getErrorMessage());
        }
    }

    private PitanjeServis$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pitanjaPoOblastima = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

