/*
 * Decompiled with CFR 0.152.
 */
package de.nixosoft.jlr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class JLRGenerator {
    private String errorMessage = "No errors occurred!";
    private String outputStream = "";
    private File inputFile = null;
    private File pdfFile = null;
    private File auxFile = null;
    private File logFile = null;
    private boolean deleteTempTex = false;
    private boolean deleteAux = false;
    private boolean deleteLog = false;
    private static String newline = System.getProperty("line.separator");

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getOutputStream() {
        return this.outputStream;
    }

    public File getPDF() {
        return this.pdfFile;
    }

    public void deleteTempFiles(boolean bl, boolean bl2, boolean bl3) {
        this.deleteTempTex = bl;
        this.deleteAux = bl2;
        this.deleteLog = bl3;
    }

    public boolean generate(File file, File file2, File file3) throws IOException {
        return this.generate(new File("pdflatex"), 3, file, file2, file3);
    }

    public boolean generate(int n, File file, File file2, File file3) throws IOException {
        return this.generate(new File("pdflatex"), n, file, file2, file3);
    }

    public boolean generate(File file, File file2, File file3, File file4) throws IOException {
        return this.generate(file, 3, file2, file3, file4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(File file, int n, File file2, File file3, File file4) throws IOException {
        this.inputFile = file2;
        if (!this.checkingInputs(n, file2, file3, file4)) {
            return false;
        }
        String string = file.getPath();
        String string2 = "--interaction=nonstopmode";
        String string3 = "--output-directory=" + file3.getAbsolutePath();
        String string4 = "--aux-directory=" + file2.getParent();
        String string5 = file2.getAbsolutePath();
        ProcessBuilder processBuilder = new ProcessBuilder(string, string2, string3, string4, string5);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(file4);
        for (int i = 1; i <= n; ++i) {
            Process process = processBuilder.start();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = null;
            try {
                while ((string6 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string6 + newline);
                }
            }
            finally {
                bufferedReader.close();
            }
            this.outputStream = stringBuilder.toString();
            try {
                int n2 = process.waitFor();
                if (!this.determiningFiles(file2, file3)) {
                    return false;
                }
                if (n2 != 0) {
                    this.errorMessage = "Errors occurred while executing pdfLaTeX! Exit value of the process: " + n2;
                    return false;
                }
                this.errorMessage = "No errors occurred!";
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.errorMessage = "The process pdfLaTeX was interrupted and an exception occurred!" + newline + interruptedException.toString();
                return false;
            }
        }
        this.cleanUp();
        return true;
    }

    private boolean checkingInputs(int n, File file, File file2, File file3) throws IOException {
        if (n <= 0) {
            this.errorMessage = "The value for \"cycles\" has to be greater than 0!";
            return false;
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " does not exist or is not a file!");
        }
        if (file2 != null && !file2.isDirectory() && !file2.mkdirs()) {
            this.errorMessage = "Could not create directory: " + file2.getAbsolutePath();
            return false;
        }
        if (!file3.isDirectory()) {
            throw new IOException("The directory " + file3.getAbsolutePath() + " does not exist or is not a directory!");
        }
        return true;
    }

    private boolean determiningFiles(File file, File file2) {
        File file3 = null;
        int n = file.getName().lastIndexOf(".");
        if (n != -1) {
            this.auxFile = new File(file.getParent() + File.separator + file.getName().substring(0, n) + ".aux");
            this.logFile = new File(file.getParent() + File.separator + file.getName().substring(0, n) + ".log");
            file3 = new File(file2.getAbsolutePath() + File.separator + file.getName().substring(0, n) + ".pdf");
        } else {
            this.auxFile = new File(file.getParent() + File.separator + file.getName() + ".aux");
            this.logFile = new File(file.getParent() + File.separator + file.getName() + ".log");
            file3 = new File(file2.getAbsolutePath() + File.separator + file.getName() + ".pdf");
        }
        if (file3.isFile()) {
            this.pdfFile = file3;
            return true;
        }
        this.errorMessage = "The pdf file could not be created or does not exist!";
        return false;
    }

    private void cleanUp() {
        if (this.deleteAux) {
            this.deleteFile(this.auxFile);
        }
        if (this.deleteLog) {
            this.deleteFile(this.logFile);
        }
        if (this.deleteTempTex) {
            this.deleteFile(this.inputFile);
        }
    }

    private void deleteFile(File file) {
        if (file.isFile() && !file.delete()) {
            this.errorMessage = "Warning: Could not remove " + file.getAbsolutePath() + " !";
        }
    }
}

