/*
 * Decompiled with CFR 0.152.
 */
package de.nixosoft.jlr;

import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class JLROpener {
    private static String newline = System.getProperty("line.separator");

    private JLROpener() {
    }

    public static void open(File file, File file2) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " does not exist or is not a file!");
        }
        if (!file2.isFile()) {
            throw new FileNotFoundException("The file " + file2.getAbsolutePath() + " does not exist or is not a file!");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath(), file2.getAbsolutePath());
        processBuilder.start();
    }

    public static void open(File file) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " does not exist or is not a file!");
        }
        Desktop desktop = null;
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Could not open " + file.getAbsolutePath() + newline + "The specified file has no associated application or the associated application fails to be launched!", "FileOpenError", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not open " + file.getAbsolutePath() + newline + "Desktop.Action.OPEN is not supported!", "FileOpenError", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Could not open " + file.getAbsolutePath() + newline + "Desktop is not supported on the current platform!", "FileOpenError", 0);
        }
    }

    public static void print(File file) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " does not exist or is not a file!");
        }
        Desktop desktop = null;
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.PRINT)) {
                try {
                    Desktop.getDesktop().print(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Could not print " + file.getAbsolutePath() + newline + "The specified file has no associated application or the associated application fails to be launched!", "FileOpenError", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not print " + file.getAbsolutePath() + newline + "Desktop.Action.PRINT is not supported!", "FilePrintError", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Could not print " + file.getAbsolutePath() + newline + "Desktop is not supported on the current platform!", "FilePrintError", 0);
        }
    }
}

