/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.TableRowSkin;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.SpreadsheetViewSelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRowSkin
extends TableRowSkin<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;

    public GridRowSkin(SpreadsheetHandle handle, GridRow gridRow) {
        super((TableRow)gridRow);
        this.handle = handle;
        this.spreadsheetView = handle.getView();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList visibleLeafColumns = this.getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h);
            return;
        }
        GridRow control = (GridRow)this.getSkinnable();
        SpreadsheetGridView gridView = this.handle.getGridView();
        Grid grid = this.spreadsheetView.getGrid();
        int index = control.getIndex();
        if (index < 0 || index >= gridView.getItems().size()) {
            return;
        }
        List row = (List)grid.getRows().get(index);
        ObservableList<SpreadsheetColumn> columns = this.spreadsheetView.getColumns();
        ObservableList tableViewColumns = gridView.getColumns();
        if (columns.size() != tableViewColumns.size()) {
            return;
        }
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double controlHeight = this.getTableRowHeight(index);
        this.handle.getCellsViewSkin().hBarValue.set(index, true);
        double headerWidth = gridView.getWidth();
        ((GridRow)this.getSkinnable()).verticalShift.setValue((Number)this.getFixedRowShift(index));
        double fixedColumnWidth = 0.0;
        ArrayList<CellView> fixedCells = new ArrayList<CellView>();
        block6: for (int column = 0; column < this.cells.size(); ++column) {
            boolean isVisible;
            CellView tableCell = (CellView)((Object)this.cells.get(column));
            tableCell.setManaged(true);
            double width = this.snapSize(tableCell.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
            double height = controlHeight;
            height = this.snapSize(height) - this.snapSize(verticalPadding);
            double tableCellX = 0.0;
            double hbarValue = this.handle.getCellsViewSkin().getHBar().getValue();
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)row.get(column);
            boolean bl = isVisible = !this.isInvisible(x, width, hbarValue, headerWidth, spreadsheetCell.getColumnSpan());
            if (((SpreadsheetColumn)columns.get(column)).isFixed() && hbarValue + fixedColumnWidth > x) {
                tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                fixedColumnWidth += tableCell.getWidth();
                isVisible = true;
                fixedCells.add(tableCell);
            }
            if (isVisible) {
                SpreadsheetView.SpanType spanType = grid.getSpanType(this.spreadsheetView, index, column);
                switch (spanType) {
                    case ROW_SPAN_INVISIBLE: 
                    case BOTH_INVISIBLE: {
                        fixedCells.remove((Object)tableCell);
                        this.getChildren().remove((Object)tableCell);
                        x += width;
                        continue block6;
                    }
                    case COLUMN_SPAN_INVISIBLE: {
                        fixedCells.remove((Object)tableCell);
                        this.getChildren().remove((Object)tableCell);
                        continue block6;
                    }
                    case ROW_VISIBLE: {
                        SpreadsheetViewSelectionModel sm = (SpreadsheetViewSelectionModel)this.spreadsheetView.getSelectionModel();
                        TableColumn col = (TableColumn)tableViewColumns.get(column);
                        TablePosition<ObservableList<SpreadsheetCell>, ?> selectedPosition = sm.isSelectedRange(index, col, column);
                        if (selectedPosition != null && this.handle.getCellsViewSkin().containsRow(index) && selectedPosition.getRow() != index) {
                            sm.clearSelection(selectedPosition.getRow(), selectedPosition.getTableColumn());
                            sm.select(index, col);
                        }
                    }
                    case NORMAL_CELL: {
                        tableCell.show();
                        if (tableCell.getParent() == null) {
                            this.getChildren().add(0, (Object)tableCell);
                        }
                    }
                    default: {
                        if (spreadsheetCell.getColumnSpan() > 1) {
                            int colSpan = spreadsheetCell.getColumnSpan();
                            int max1 = this.cells.size() - column;
                            for (int i = 1; i < colSpan && i < max1; ++i) {
                                width += this.snapSize(((SpreadsheetColumn)columns.get(column + i)).getWidth());
                            }
                        }
                        if (spreadsheetCell.getRowSpan() > 1) {
                            height = 0.0;
                            int maxRow = spreadsheetCell.getRow() + spreadsheetCell.getRowSpan();
                            for (int i = spreadsheetCell.getRow(); i < maxRow; ++i) {
                                height += this.snapSize(this.getTableRowHeight(i));
                            }
                        }
                        tableCell.resize(width, height);
                        double spaceBetweenTopAndMe = 0.0;
                        for (int p = spreadsheetCell.getRow(); p < index; ++p) {
                            spaceBetweenTopAndMe += this.getTableRowHeight(p);
                        }
                        tableCell.relocate(x + tableCellX, this.snappedTopInset() - spaceBetweenTopAndMe + ((GridRow)this.getSkinnable()).verticalShift.get());
                        break;
                    }
                }
            } else {
                this.getChildren().remove((Object)tableCell);
            }
            x += width;
        }
        this.handle.getCellsViewSkin().fixedColumnWidth = fixedColumnWidth;
        this.handleFixedCell(fixedCells, index);
    }

    private void handleFixedCell(List<CellView> fixedCells, int index) {
        block5: {
            block4: {
                if (!this.handle.getCellsViewSkin().rowToLayout.get(index)) break block4;
                GridRow gridRow = this.handle.getCellsViewSkin().getFlow().getTopRow();
                if (gridRow == null) break block5;
                for (CellView cell : fixedCells) {
                    double originalLayoutY = ((TableRow)this.getSkinnable()).getLayoutY() + cell.getLayoutY();
                    gridRow.removeCell(cell);
                    gridRow.addCell(cell);
                    if (this.handle.getCellsViewSkin().deportedCells.containsKey((Object)gridRow)) {
                        this.handle.getCellsViewSkin().deportedCells.get((Object)gridRow).add(cell);
                    } else {
                        HashSet<CellView> temp = new HashSet<CellView>();
                        temp.add(cell);
                        this.handle.getCellsViewSkin().deportedCells.put(gridRow, temp);
                    }
                    cell.relocate(cell.getLayoutX(), originalLayoutY - gridRow.getLayoutY());
                }
                break block5;
            }
            for (CellView cell : fixedCells) {
                cell.toFront();
            }
        }
    }

    private double getFixedRowShift(int index) {
        double tableCellY = 0.0;
        int positionY = this.spreadsheetView.getFixedRows().indexOf((Object)index);
        double space = 0.0;
        for (int o = 0; o < positionY; ++o) {
            space += this.getTableRowHeight((Integer)this.spreadsheetView.getFixedRows().get(o));
        }
        if (positionY != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= space) {
            tableCellY = space - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().add((Object)index);
        } else {
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().remove((Object)index);
        }
        return tableCellY;
    }

    private double getTableRowHeight(int i) {
        return this.handle.getCellsViewSkin().getRowHeight(i);
    }

    private boolean isInvisible(double x, double width, double hbarValue, double headerWidth, int columnSpan) {
        return x + width < hbarValue && columnSpan == 1 || x > hbarValue + headerWidth;
    }
}

