/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.action.AnnotatedAction;

public class ActionMap {
    private static Map<String, AnnotatedAction> actions = new HashMap<String, AnnotatedAction>();

    private ActionMap() {
    }

    public static void register(Object target) {
        for (Method method : target.getClass().getDeclaredMethods()) {
            String id;
            Annotation[] annotations;
            int paramCount = method.getParameterCount();
            if (paramCount > 1 || paramCount == 1 && method.getParameterTypes()[0] != ActionEvent.class || (annotations = method.getAnnotationsByType(ActionProxy.class)).length <= 0) continue;
            ActionProxy annotation = (ActionProxy)annotations[0];
            String string = id = annotation.id().isEmpty() ? method.getName() : annotation.id();
            if (actions.containsKey(id)) {
                throw new IllegalArgumentException(String.format("Action proxy with key = '%s' already exists", id));
            }
            actions.put(id, new AnnotatedAction(annotation, method, target));
        }
    }

    public void unregister(Object target) {
        if (target != null) {
            for (String key : actions.keySet()) {
                if (actions.get(key).getTarget() != target) continue;
                actions.remove(key);
            }
        }
    }

    public static Action action(String id) {
        return actions.get(id);
    }

    public static Collection<Action> actions(String ... ids) {
        ArrayList<Action> result2 = new ArrayList<Action>();
        for (String id : ids) {
            Action action;
            if (id.startsWith("---")) {
                result2.add(ActionUtils.ACTION_SEPARATOR);
            }
            if ((action = ActionMap.action(id)) == null) continue;
            result2.add(action);
        }
        return result2;
    }
}

