/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Pair;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.textfield.CustomPasswordField;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.dialog.Dialog;
import org.controlsfx.dialog.DialogAction;
import org.controlsfx.dialog.DialogResources;
import org.controlsfx.dialog.ExceptionDialogImpl;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

@Deprecated
public final class Dialogs {
    public static final String USE_DEFAULT = "$$$";
    private Object owner;
    private String title = "$$$";
    private Node graphic;
    private String message;
    private String masthead;
    private boolean lightweight;
    private Set<Action> actions = new LinkedHashSet<Action>();
    private Effect backgroundEffect;
    private List<String> styleClasses;

    public static Dialogs create() {
        return new Dialogs();
    }

    private Dialogs() {
    }

    public Dialogs owner(Object owner) {
        this.owner = owner;
        return this;
    }

    public Dialogs title(String title) {
        this.title = title;
        return this;
    }

    public Dialogs graphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    public Dialogs message(String message) {
        this.message = message;
        return this;
    }

    public Dialogs masthead(String masthead) {
        this.masthead = masthead;
        return this;
    }

    public Dialogs actions(Collection<? extends Action> actions) {
        this.actions.clear();
        this.actions.addAll(actions);
        return this;
    }

    public Dialogs actions(Action ... actions) {
        return this.actions(Arrays.asList(actions));
    }

    public Dialogs backgroundEffect(Effect effect) {
        this.backgroundEffect = effect;
        return this;
    }

    public Dialogs lightweight() {
        this.lightweight = true;
        return this;
    }

    public Dialogs styleClass(String styleClass) {
        if (this.styleClasses == null) {
            this.styleClasses = new ArrayList<String>();
        }
        this.styleClasses.add(styleClass);
        return this;
    }

    public void showInformation() {
        this.showSimpleContentDialog(Type.INFORMATION);
    }

    public Action showConfirm() {
        return this.showSimpleContentDialog(Type.CONFIRMATION);
    }

    public Action showWarning() {
        return this.showSimpleContentDialog(Type.WARNING);
    }

    public Action showError() {
        return this.showSimpleContentDialog(Type.ERROR);
    }

    public Action showException(Throwable exception) {
        Dialog dlg = this.buildDialog(Type.ERROR);
        dlg.setContent(this.message != null && !this.message.isEmpty() ? this.message : exception.getMessage());
        dlg.setExpandableContent(this.buildExceptionDetails(exception));
        if (!this.actions.isEmpty()) {
            dlg.getActions().clear();
            dlg.getActions().addAll(this.actions);
        }
        return dlg.show();
    }

    public Action showExceptionInNewWindow(Throwable exception) {
        Dialog dlg = this.buildDialog(Type.ERROR);
        dlg.setContent(this.message != null && !this.message.isEmpty() ? this.message : exception.getMessage());
        dlg.getActions().clear();
        Action openExceptionAction = new Action(Localization.localize(Localization.asKey("exception.button.label")), ae -> {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String moreDetails = sw.toString();
            new ExceptionDialogImpl((Window)this.owner, moreDetails).show();
        });
        ButtonBar.setType(openExceptionAction, ButtonBar.ButtonType.HELP_2);
        dlg.getActions().add((Object)openExceptionAction);
        if (!this.actions.isEmpty()) {
            dlg.getActions().addAll(this.actions);
        }
        return dlg.show();
    }

    public Optional<String> showTextInput(String defaultValue) {
        Dialog dlg = this.buildDialog(Type.INPUT);
        TextField textField = new TextField(defaultValue);
        dlg.setContent(this.buildInputContent((Control)textField));
        return Optional.ofNullable(dlg.show() == Dialog.ACTION_OK ? textField.getText() : null);
    }

    public Optional<String> showTextInput() {
        return this.showTextInput("");
    }

    public <T> Optional<T> showChoices(T defaultChoice, Collection<T> choices) {
        Dialog dlg = this.buildDialog(Type.INPUT);
        double MIN_WIDTH = 150.0;
        SingleSelectionModel selectionModel = null;
        if (choices.size() > 10) {
            ComboBox comboBox = new ComboBox();
            comboBox.setMinWidth(150.0);
            comboBox.getItems().addAll(choices);
            selectionModel = comboBox.getSelectionModel();
            dlg.setContent(this.buildInputContent((Control)comboBox));
        } else {
            ChoiceBox choiceBox = new ChoiceBox();
            choiceBox.setMinWidth(150.0);
            choiceBox.getItems().addAll(choices);
            selectionModel = choiceBox.getSelectionModel();
            dlg.setContent(this.buildInputContent((Control)choiceBox));
        }
        if (defaultChoice == null) {
            selectionModel.selectFirst();
        } else {
            selectionModel.select(defaultChoice);
        }
        return Optional.ofNullable(dlg.show() == Dialog.ACTION_OK ? selectionModel.getSelectedItem() : null);
    }

    public <T> Optional<T> showChoices(Collection<T> choices) {
        return this.showChoices((T)null, choices);
    }

    public <T> Optional<T> showChoices(T ... choices) {
        return this.showChoices((Collection<T>)Arrays.asList(choices));
    }

    public Action showCommandLinks(List<DialogAction> links) {
        final Dialog dlg = this.buildDialog(Type.INFORMATION);
        dlg.setContent(this.message);
        Node messageNode = dlg.getContent();
        messageNode.getStyleClass().add((Object)"command-link-message");
        int gapSize = 10;
        final ArrayList<Button> buttons = new ArrayList<Button>(links.size());
        GridPane content = new GridPane(){

            protected double computePrefWidth(double height) {
                double pw = 0.0;
                for (int i = 0; i < buttons.size(); ++i) {
                    Button btn = (Button)buttons.get(i);
                    pw = Math.min(pw, btn.prefWidth(-1.0));
                }
                return pw + 10.0;
            }

            protected double computePrefHeight(double width) {
                double ph = Dialogs.this.masthead == null || Dialogs.this.masthead.isEmpty() ? 0.0 : 10.0;
                for (int i = 0; i < buttons.size(); ++i) {
                    Button btn = (Button)buttons.get(i);
                    ph += btn.prefHeight(width) + 10.0;
                }
                return ph * 1.5;
            }
        };
        content.setHgap(10.0);
        content.setVgap(10.0);
        int row = 0;
        Node message = dlg.getContent();
        if (message != null) {
            content.add(message, 0, row++);
        }
        for (final DialogAction commandLink : links) {
            if (commandLink == null) continue;
            Button button = this.buildCommandLinkButton(commandLink);
            button.setDefaultButton(commandLink.isDefault());
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    commandLink.handle(new ActionEvent((Object)dlg, ae.getTarget()));
                }
            });
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            content.add((Node)button, 0, row++);
            buttons.add(button);
        }
        GridPane.setMargin((Node)((Node)buttons.get(buttons.size() - 1)), (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        dlg.setContent((Node)content);
        dlg.getActions().clear();
        return dlg.show();
    }

    public Action showCommandLinks(DialogAction ... links) {
        return this.showCommandLinks(Arrays.asList(links));
    }

    public Optional<Font> showFontSelector(Font font) {
        FontPanel fontPanel = new FontPanel();
        fontPanel.setFont(font);
        this.title(USE_DEFAULT);
        Dialog dlg = this.buildDialog(Type.FONT);
        dlg.setIconifiable(false);
        dlg.setContent((Node)fontPanel);
        return Optional.ofNullable(Dialog.ACTION_OK == dlg.show() ? fontPanel.getFont() : null);
    }

    public void showWorkerProgress(Worker<?> worker) {
        Dialog dlg = this.buildDialog(Type.PROGRESS);
        dlg.setClosable(false);
        Label progressMessage = new Label();
        progressMessage.textProperty().bind((ObservableValue)worker.messageProperty());
        WorkerProgressPane content = new WorkerProgressPane(dlg);
        content.setMaxWidth(Double.MAX_VALUE);
        VBox vbox = new VBox(10.0, new Node[]{progressMessage, content});
        vbox.setMaxWidth(Double.MAX_VALUE);
        vbox.setPrefSize(300.0, 100.0);
        if (this.message != null) {
            vbox.getChildren().add(0, (Object)new Label(this.message));
        }
        dlg.setContent((Node)vbox);
        content.setWorker(worker);
    }

    public Optional<Pair<String, String>> showLogin(Pair<String, String> initialUserInfo, final Callback<Pair<String, String>, Void> authenticator) {
        final CustomTextField txUserName = (CustomTextField)TextFields.createClearableTextField();
        txUserName.setLeft((Node)new ImageView(DialogResources.getImage("login.user.icon")));
        final CustomPasswordField txPassword = (CustomPasswordField)TextFields.createClearablePasswordField();
        txPassword.setLeft((Node)new ImageView(DialogResources.getImage("login.password.icon")));
        final Label lbMessage = new Label("");
        lbMessage.getStyleClass().addAll((Object[])new String[]{"message-banner"});
        lbMessage.setVisible(false);
        lbMessage.setManaged(false);
        VBox content = new VBox(10.0);
        content.getChildren().add((Object)lbMessage);
        content.getChildren().add((Object)txUserName);
        content.getChildren().add((Object)txPassword);
        DialogAction actionLogin = new DialogAction(Localization.getString("login.dlg.login.button"), null, false, false, true){
            {
                super(text, buttonType, cancelAction, closingAction, defaultAction);
                ButtonBar.setType(this, ButtonBar.ButtonType.OK_DONE);
                this.setEventHandler(this::handleAction);
            }

            protected void handleAction(ActionEvent ae) {
                Dialog dlg = (Dialog)ae.getSource();
                try {
                    if (authenticator != null) {
                        authenticator.call((Object)new Pair((Object)txUserName.getText(), (Object)txPassword.getText()));
                    }
                    lbMessage.setVisible(false);
                    lbMessage.setManaged(false);
                    dlg.hide();
                    dlg.setResult(this);
                }
                catch (Throwable ex) {
                    lbMessage.setVisible(true);
                    lbMessage.setManaged(true);
                    lbMessage.setText(ex.getMessage());
                    dlg.sizeToScene();
                    dlg.shake();
                    ex.printStackTrace();
                }
            }

            public String toString() {
                return "LOGIN";
            }
        };
        Dialog dlg = this.buildDialog(Type.LOGIN);
        dlg.setContent((Node)content);
        dlg.setResizable(false);
        dlg.setIconifiable(false);
        if (dlg.getGraphic() == null) {
            dlg.setGraphic((Node)new ImageView(DialogResources.getImage("login.icon")));
        }
        dlg.getActions().setAll((Object[])new Action[]{actionLogin, Dialog.ACTION_CANCEL});
        String userNameCation = Localization.getString("login.dlg.user.caption");
        String passwordCaption = Localization.getString("login.dlg.pswd.caption");
        txUserName.setPromptText(userNameCation);
        txUserName.setText((String)initialUserInfo.getKey());
        txPassword.setPromptText(passwordCaption);
        txPassword.setText(new String((String)initialUserInfo.getValue()));
        ValidationSupport validationSupport = new ValidationSupport();
        Platform.runLater(() -> {
            String requiredFormat = "'%s' is required";
            validationSupport.registerValidator((Control)txUserName, Validator.createEmptyValidator(String.format(requiredFormat, userNameCation)));
            validationSupport.registerValidator((Control)txPassword, Validator.createEmptyValidator(String.format(requiredFormat, passwordCaption)));
            actionLogin.disabledProperty().bind((ObservableValue)validationSupport.invalidProperty());
            txUserName.requestFocus();
        });
        dlg.sizeToScene();
        return Optional.ofNullable(dlg.show() == actionLogin ? new Pair((Object)txUserName.getText(), (Object)txPassword.getText()) : null);
    }

    private Dialog buildDialog(Type dlgType) {
        String actualTitle;
        String string = this.title == null ? null : (actualTitle = USE_DEFAULT.equals(this.title) ? dlgType.getDefaultTitle() : this.title);
        String actualMasthead = this.masthead == null ? null : (USE_DEFAULT.equals(this.masthead) ? dlgType.getDefaultMasthead() : this.masthead);
        Dialog dlg = new Dialog(this.owner, actualTitle, this.lightweight);
        dlg.updateStyleClasses(this.styleClasses, true);
        dlg.setResizable(false);
        dlg.setIconifiable(false);
        if (this.graphic != null) {
            dlg.setGraphic(this.graphic);
        } else if (dlgType.getImage() != null) {
            dlg.setGraphic((Node)new ImageView(dlgType.getImage()));
        }
        dlg.setMasthead(actualMasthead);
        dlg.getActions().addAll(dlgType.getActions());
        dlg.setBackgroundEffect(this.backgroundEffect);
        return dlg;
    }

    private Action showSimpleContentDialog(Type dlgType) {
        Dialog dlg = this.buildDialog(dlgType);
        if (!this.actions.isEmpty()) {
            dlg.getActions().clear();
            dlg.getActions().addAll(this.actions);
        }
        dlg.setContent(this.message);
        return dlg.show();
    }

    private Node buildInputContent(Control inputControl) {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        if (this.message != null && !this.message.isEmpty()) {
            Label label = new Label(this.message);
            GridPane.setHgrow((Node)label, (Priority)Priority.NEVER);
            grid.add((Node)label, 0, 0);
        }
        if (inputControl != null) {
            inputControl.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)inputControl, (Priority)Priority.ALWAYS);
            grid.add((Node)inputControl, 1, 0);
            Platform.runLater(() -> inputControl.requestFocus());
        }
        return grid;
    }

    private Node buildExceptionDetails(Throwable exception) {
        Label label = new Label(Localization.localize(Localization.asKey("exception.dlg.label")));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        TextArea textArea = new TextArea(sw.toString());
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane root = new GridPane();
        root.setMaxWidth(Double.MAX_VALUE);
        root.add((Node)label, 0, 0);
        root.add((Node)textArea, 0, 1);
        return root;
    }

    private Button buildCommandLinkButton(DialogAction commandLink) {
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"command-link-button"});
        button.setMaxHeight(Double.MAX_VALUE);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setAlignment(Pos.CENTER_LEFT);
        final Label titleLabel = new Label(commandLink.getText());
        titleLabel.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{titleLabel.prefWidthProperty()});
            }

            protected double computeValue() {
                return titleLabel.getPrefWidth() + 400.0;
            }
        });
        titleLabel.getStyleClass().addAll((Object[])new String[]{"line-1"});
        titleLabel.setWrapText(true);
        titleLabel.setAlignment(Pos.TOP_LEFT);
        GridPane.setVgrow((Node)titleLabel, (Priority)Priority.NEVER);
        Label messageLabel = new Label(commandLink.getLongText());
        messageLabel.getStyleClass().addAll((Object[])new String[]{"line-2"});
        messageLabel.setWrapText(true);
        messageLabel.setAlignment(Pos.TOP_LEFT);
        messageLabel.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)messageLabel, (Priority)Priority.SOMETIMES);
        Node graphic = commandLink.getGraphic();
        Node view = graphic == null ? new ImageView(DialogResources.getImage("command.link.icon")) : graphic;
        Pane graphicContainer = new Pane(new Node[]{view});
        graphicContainer.getStyleClass().add((Object)"graphic-container");
        GridPane.setValignment((Node)graphicContainer, (VPos)VPos.TOP);
        GridPane.setMargin((Node)graphicContainer, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane grid = new GridPane();
        grid.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        grid.setMaxHeight(Double.MAX_VALUE);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.getStyleClass().add((Object)"container");
        grid.add((Node)graphicContainer, 0, 0, 1, 2);
        grid.add((Node)titleLabel, 1, 0);
        grid.add((Node)messageLabel, 1, 1);
        button.setGraphic((Node)grid);
        button.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        return button;
    }

    private static class WorkerProgressPane
    extends Region {
        private Worker<?> worker;
        private boolean dialogVisible = false;
        private boolean cancelDialogShow = false;
        private ChangeListener<Worker.State> stateListener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State old, Worker.State value) {
                switch (value) {
                    case CANCELLED: 
                    case FAILED: 
                    case SUCCEEDED: {
                        if (!dialogVisible) {
                            cancelDialogShow = true;
                            break;
                        }
                        if (old != Worker.State.SCHEDULED && old != Worker.State.RUNNING) break;
                        this.end();
                        break;
                    }
                    case SCHEDULED: {
                        this.begin();
                        break;
                    }
                }
            }
        };
        private final Dialog dialog;
        private final ProgressBar progressBar;

        public final void setWorker(Worker<?> newWorker) {
            if (newWorker != this.worker) {
                if (this.worker != null) {
                    this.worker.stateProperty().removeListener(this.stateListener);
                    this.end();
                }
                this.worker = newWorker;
                if (newWorker != null) {
                    newWorker.stateProperty().addListener(this.stateListener);
                    if (newWorker.getState() == Worker.State.RUNNING || newWorker.getState() == Worker.State.SCHEDULED) {
                        this.begin();
                    }
                }
            }
        }

        public WorkerProgressPane(Dialog dialog) {
            this.dialog = dialog;
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)this.progressBar);
            if (this.worker != null) {
                this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
            }
        }

        private void begin() {
            this.cancelDialogShow = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!cancelDialogShow) {
                        progressBar.progressProperty().bind((ObservableValue)worker.progressProperty());
                        dialogVisible = true;
                        dialog.show();
                    }
                }
            });
        }

        private void end() {
            this.progressBar.progressProperty().unbind();
            this.dialogVisible = false;
            this.dialog.hide();
        }

        protected void layoutChildren() {
            if (this.progressBar != null) {
                Insets insets = this.getInsets();
                double w = this.getWidth() - insets.getLeft() - insets.getRight();
                double h = this.getHeight() - insets.getTop() - insets.getBottom();
                double prefH = this.progressBar.prefHeight(-1.0);
                double x = insets.getLeft() + (w - w) / 2.0;
                double y = insets.getTop() + (h - prefH) / 2.0;
                this.progressBar.resizeRelocate(x, y, w, prefH);
            }
        }
    }

    private static class FontPanel
    extends GridPane {
        private static final double HGAP = 10.0;
        private static final double VGAP = 5.0;
        private static final Predicate<Object> MATCH_ALL = new Predicate<Object>(){

            @Override
            public boolean test(Object t) {
                return true;
            }
        };
        private static final Double[] fontSizes = new Double[]{8.0, 9.0, 11.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 36.0, 48.0, 72.0};
        private final FilteredList<String> filteredFontList = new FilteredList(FXCollections.observableArrayList((Collection)Font.getFamilies()), MATCH_ALL);
        private final FilteredList<FontStyle> filteredStyleList = new FilteredList(FXCollections.observableArrayList(), MATCH_ALL);
        private final FilteredList<Double> filteredSizeList = new FilteredList(FXCollections.observableArrayList((Object[])fontSizes), MATCH_ALL);
        private final ListView<String> fontListView = new ListView(this.filteredFontList);
        private final ListView<FontStyle> styleListView = new ListView(this.filteredStyleList);
        private final ListView<Double> sizeListView = new ListView(this.filteredSizeList);
        private final Text sample = new Text(Localization.localize(Localization.asKey("font.dlg.sample.text")));

        private static List<FontStyle> getFontStyles(String fontFamily) {
            HashSet<FontStyle> set = new HashSet<FontStyle>();
            for (String f : Font.getFontNames((String)fontFamily)) {
                set.add(new FontStyle(f.replace(fontFamily, "")));
            }
            ArrayList<FontStyle> result2 = new ArrayList<FontStyle>(set);
            Collections.sort(result2);
            return result2;
        }

        public FontPanel() {
            this.setHgap(10.0);
            this.setVgap(5.0);
            this.setPrefSize(500.0, 300.0);
            this.setMinSize(500.0, 300.0);
            ColumnConstraints c0 = new ColumnConstraints();
            c0.setPercentWidth(60.0);
            ColumnConstraints c1 = new ColumnConstraints();
            c1.setPercentWidth(25.0);
            ColumnConstraints c2 = new ColumnConstraints();
            c2.setPercentWidth(15.0);
            this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c0, c1, c2});
            RowConstraints r0 = new RowConstraints();
            r0.setVgrow(Priority.NEVER);
            RowConstraints r1 = new RowConstraints();
            r1.setVgrow(Priority.NEVER);
            RowConstraints r2 = new RowConstraints();
            r2.setFillHeight(true);
            r2.setVgrow(Priority.NEVER);
            RowConstraints r3 = new RowConstraints();
            r3.setPrefHeight(250.0);
            r3.setVgrow(Priority.NEVER);
            this.getRowConstraints().addAll((Object[])new RowConstraints[]{r0, r1, r2, r3});
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.font.label"))), 0, 0);
            this.add((Node)this.fontListView, 0, 1);
            this.fontListView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listview) {
                    return new ListCell<String>(){

                        protected void updateItem(String family, boolean empty) {
                            super.updateItem((Object)family, empty);
                            if (!empty) {
                                this.setFont(Font.font((String)family));
                                this.setText(family);
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                }
            });
            ChangeListener<Object> sampleRefreshListener = new ChangeListener<Object>(){

                public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                    this.refreshSample();
                }
            };
            ((MultipleSelectionModel)this.fontListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                    String fontFamily = (String)this.listSelection(fontListView);
                    styleListView.setItems(FXCollections.observableArrayList((Collection)FontPanel.getFontStyles(fontFamily)));
                    this.refreshSample();
                }
            });
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.style.label"))), 1, 0);
            this.add((Node)this.styleListView, 1, 1);
            ((MultipleSelectionModel)this.styleListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)sampleRefreshListener);
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.size.label"))), 2, 0);
            this.add((Node)this.sizeListView, 2, 1);
            ((MultipleSelectionModel)this.sizeListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)sampleRefreshListener);
            double height = 45.0;
            DoubleBinding sampleWidth = new DoubleBinding(){
                {
                    this.bind(new Observable[]{fontListView.widthProperty(), styleListView.widthProperty(), sizeListView.widthProperty()});
                }

                protected double computeValue() {
                    return fontListView.getWidth() + styleListView.getWidth() + sizeListView.getWidth() + 30.0;
                }
            };
            StackPane sampleStack = new StackPane(new Node[]{this.sample});
            sampleStack.setAlignment(Pos.CENTER_LEFT);
            sampleStack.setMinHeight(45.0);
            sampleStack.setPrefHeight(45.0);
            sampleStack.setMaxHeight(45.0);
            sampleStack.prefWidthProperty().bind((ObservableValue)sampleWidth);
            Rectangle clip = new Rectangle(0.0, 45.0);
            clip.widthProperty().bind((ObservableValue)sampleWidth);
            sampleStack.setClip((Node)clip);
            this.add((Node)sampleStack, 0, 3, 1, 3);
        }

        public void setFont(Font font) {
            Font _font;
            Font font2 = _font = font == null ? Font.getDefault() : font;
            if (_font != null) {
                this.selectInList(this.fontListView, _font.getFamily());
                this.selectInList(this.styleListView, new FontStyle(_font));
                this.selectInList(this.sizeListView, _font.getSize());
            }
        }

        public Font getFont() {
            try {
                FontStyle style = this.listSelection(this.styleListView);
                if (style == null) {
                    return Font.font((String)this.listSelection(this.fontListView), (double)this.listSelection(this.sizeListView));
                }
                return Font.font((String)this.listSelection(this.fontListView), (FontWeight)style.getWeight(), (FontPosture)style.getPosture(), (double)this.listSelection(this.sizeListView));
            }
            catch (Throwable ex) {
                return null;
            }
        }

        private void refreshSample() {
            System.out.println(this.getFont());
            this.sample.setFont(this.getFont());
        }

        private <T> void selectInList(final ListView<T> listView, final T selection) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    listView.scrollTo(selection);
                    listView.getSelectionModel().select(selection);
                }
            });
        }

        private <T> T listSelection(ListView<T> listView) {
            return (T)((MultipleSelectionModel)listView.selectionModelProperty().get()).getSelectedItem();
        }
    }

    private static class FontStyle
    implements Comparable<FontStyle> {
        private FontPosture posture;
        private FontWeight weight;

        public FontStyle(FontWeight weight, FontPosture posture) {
            this.posture = posture == null ? FontPosture.REGULAR : posture;
            this.weight = weight;
        }

        public FontStyle() {
            this(null, null);
        }

        public FontStyle(String styles) {
            this();
            String[] fontStyles;
            for (String style : fontStyles = (styles == null ? "" : styles.trim().toUpperCase()).split(" ")) {
                FontWeight w = FontWeight.findByName((String)style);
                if (w != null) {
                    this.weight = w;
                    continue;
                }
                FontPosture p = FontPosture.findByName((String)style);
                if (p == null) continue;
                this.posture = p;
            }
        }

        public FontStyle(Font font) {
            this(font.getStyle());
        }

        public FontPosture getPosture() {
            return this.posture;
        }

        public FontWeight getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.posture == null ? 0 : this.posture.hashCode());
            result2 = 31 * result2 + (this.weight == null ? 0 : this.weight.hashCode());
            return result2;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            FontStyle other = (FontStyle)that;
            if (this.posture != other.posture) {
                return false;
            }
            return this.weight == other.weight;
        }

        private static String makePretty(Object o) {
            String s;
            String string = s = o == null ? "" : o.toString();
            if (!s.isEmpty()) {
                s = s.replace("_", " ");
                s = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
            }
            return s;
        }

        public String toString() {
            return String.format("%s %s", FontStyle.makePretty(this.weight), FontStyle.makePretty(this.posture)).trim();
        }

        private <T extends Enum<T>> int compareEnums(T e1, T e2) {
            if (e1 == e2) {
                return 0;
            }
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            return e1.compareTo(e2);
        }

        @Override
        public int compareTo(FontStyle fs) {
            int result2 = this.compareEnums(this.weight, fs.weight);
            return result2 != 0 ? result2 : this.compareEnums(this.posture, fs.posture);
        }
    }

    private static enum Type {
        ERROR("error.image", Localization.asKey("error.dlg.title"), Localization.asKey("error.dlg.header"), Dialog.ACTION_OK),
        INFORMATION("info.image", Localization.asKey("info.dlg.title"), Localization.asKey("info.dlg.header"), Dialog.ACTION_OK),
        WARNING("warning.image", Localization.asKey("warning.dlg.title"), Localization.asKey("warning.dlg.header"), Dialog.ACTION_OK),
        CONFIRMATION("confirm.image", Localization.asKey("confirm.dlg.title"), Localization.asKey("confirm.dlg.header"), Dialog.ACTION_YES, Dialog.ACTION_NO, Dialog.ACTION_CANCEL),
        INPUT("confirm.image", Localization.asKey("input.dlg.title"), Localization.asKey("input.dlg.header"), Dialog.ACTION_OK, Dialog.ACTION_CANCEL),
        FONT(null, Localization.asKey("font.dlg.title"), Localization.asKey("font.dlg.header"), Dialog.ACTION_OK, Dialog.ACTION_CANCEL),
        PROGRESS("info.image", Localization.asKey("progress.dlg.title"), Localization.asKey("progress.dlg.header"), new Action[0]),
        LOGIN("login.icon", Localization.asKey("login.dlg.title"), Localization.asKey("login.dlg.header"), Dialog.ACTION_OK, Dialog.ACTION_CANCEL);

        private final String defaultTitle;
        private final String defaultMasthead;
        private final Collection<Action> actions;
        private final String imageResource;
        private Image image;

        private Type(String imageResource, String defaultTitle, String defaultMasthead, Action ... actions) {
            this.actions = Arrays.asList(actions);
            this.imageResource = imageResource;
            this.defaultTitle = defaultTitle;
            this.defaultMasthead = defaultMasthead;
        }

        public Image getImage() {
            if (this.image == null && this.imageResource != null) {
                this.image = DialogResources.getImage(this.imageResource);
            }
            return this.image;
        }

        public String getDefaultMasthead() {
            return Localization.localize(this.defaultMasthead);
        }

        public String getDefaultTitle() {
            return Localization.localize(this.defaultTitle);
        }

        public Collection<Action> getActions() {
            return this.actions;
        }
    }
}

