/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationMessage;

class SimpleValidationMessage
implements ValidationMessage {
    private final String text;
    private final Severity severity;
    private final Control target;

    public SimpleValidationMessage(Control target, String text, Severity severity) {
        this.text = text;
        this.severity = severity == null ? Severity.ERROR : severity;
        this.target = target;
    }

    @Override
    public Control getTarget() {
        return this.target;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.severity == null ? 0 : this.severity.hashCode());
        result2 = 31 * result2 + (this.target == null ? 0 : this.target.hashCode());
        result2 = 31 * result2 + (this.text == null ? 0 : this.text.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleValidationMessage other = (SimpleValidationMessage)obj;
        if (this.severity != other.severity) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return String.format("%s(%s)", new Object[]{this.severity, this.text});
    }
}

