/*
 * Decompiled with CFR 0.152.
 */
package de.nixosoft.jlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class JLRConverter {
    private String errorMessage = "No errors occurred!";
    private String defaultCharsetName = Charset.defaultCharset().name();
    private VelocityContext contextData;
    private VelocityEngine velocityEngine = new VelocityEngine();

    public JLRConverter(File file) {
        this(file, "org.apache.velocity.runtime.log.NullLogChute");
    }

    public JLRConverter(File file, String string) {
        this.velocityEngine.setProperty("file.resource.loader.path", file.getAbsolutePath());
        this.velocityEngine.setProperty("runtime.log.logsystem.class", string);
        this.velocityEngine.init();
        this.contextData = new VelocityContext();
    }

    public void replace(String string, Object object) {
        this.contextData.put(string, object);
    }

    public void clear() {
        this.contextData = new VelocityContext();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean parse(String string, File file) throws IOException {
        try {
            return this.parse(string, file, this.defaultCharsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errorMessage = unsupportedEncodingException.toString();
            return false;
        }
    }

    public boolean parse(String string, File file, String string2) throws UnsupportedEncodingException, IOException {
        if (file.getParentFile() != null && !file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            this.errorMessage = "Could not create directory: " + file.getParentFile().getAbsolutePath();
            return false;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        if (!this.velocityEngine.evaluate((Context)this.contextData, (Writer)bufferedWriter, "myTemplate", bufferedReader)) {
            this.errorMessage = "Errors occurred and logged to velocity log";
            bufferedWriter.flush();
            bufferedWriter.close();
            return false;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        return true;
    }

    public boolean parse(File file, File file2) throws IOException {
        try {
            return this.parse(file, file2, this.defaultCharsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errorMessage = unsupportedEncodingException.toString();
            return false;
        }
    }

    public boolean parse(File file, File file2, String string) throws UnsupportedEncodingException, IOException {
        if (file2.getParentFile() != null && !file2.getParentFile().isDirectory() && !file2.getParentFile().mkdirs()) {
            this.errorMessage = "Could not create directory: " + file2.getParentFile().getAbsolutePath();
            return false;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string));
        if (!this.velocityEngine.mergeTemplate(file.getName(), string, this.contextData, bufferedWriter)) {
            this.errorMessage = "Errors occurred and logged to velocity log";
            bufferedWriter.flush();
            bufferedWriter.close();
            return false;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        return true;
    }
}

