local ent = ents.Derive("base")

function ent:load(x, y)
	self:setPos( x, y )
	self.image = love.graphics.newImage("textures/ham.png")
	
	self.image_smoke = love.graphics.newImage("textures/smoke.png")
	self.speed = 16
	self.smokes = {}
	self.size = 0.25
	
	
	
	
	
	self.exploding = false
	self.explosion = 0
	
	self.health = 20
	self.maxhealth = self.health
	
	
	
end

function ent:setPos( x, y )
	self.x = x
	self.y = y
end



function ent:draw()
	
	if self.exploding then
		love.graphics.setColor( 255, 255, 255, 255*(1 - self.explosion) )
		love.graphics.circle( "fill", self.x, self.y, self.explosion*512, 64 )
		
		
		love.graphics.setColor( 255, 255, 255, 255*(1 - self.explosion) )
		love.graphics.draw( self.image, self.x, self.y, 0, self.size, self.size, 256, 128 )
		
		return
	end
	love.graphics.setColor( 255, 255, 255, 255 )
	love.graphics.draw( self.image, self.x, self.y, 0, self.size, self.size, 256, 128 )
	
	for k, smoke in pairs(self.smokes) do
		local s = (smoke.time/3)
		love.graphics.setColor( 255, 255, 255, (s*255) )
		love.graphics.draw( self.image_smoke, smoke.x, smoke.y - (1-s)*smoke.speed, 0, self.size*smoke.s, self.size*smoke.s, 0, 0 )
	end
end	

function ent:update(dt)

	self.x = self.x + (self.size*250)*dt
	
	if (self.x >= 850) then
	    takeScore(3)
		ents.Destroy( self.id )
	end
	


	if self.exploding then
		self.explosion = self.explosion + dt
		if self.explosion >= 1 then
			ents.Destroy( self.id )
		end
		return
	end
	
	
	for k, smoke in pairs(self.smokes) do
		smoke.time = smoke.time - dt
		if smoke.time <= 0 then
			table.remove( self.smokes, k )
		end
	end
	
	
end
function ent:Damage(n)
	if (n <= 0) or self.exploding then return end
	ent:Smoke( math.random( -128*self.size, 128*self.size ), math.random( -64*self.size, 64*self.size ) )
	self.health = self.health - n
	addScore(1)
	if self.health <= 0 then
		self.health = 0
		ent:Explode()
		addScore(3)
	end
end

function ent:Explode()
	self.exploding = true
end

function ent:Die()
	ents.Create( "ham", -256, 512, false )
end



function ent:Smoke( x, y, s, speed )
	if not x then x = 0 end
	if not y then y = 0 end
	if not s then s = 1 end
	if not speed then speed = 64 end
	table.insert( self.smokes, {time = 3, x = self.x + x, y = self.y + y, s = s, speed = speed })
end

return ent;
