local ent = ents.Derive("base")

function ent:load( x, y )
	self:setPos( x, y )
	self.image = love.graphics.newImage("textures/lazar.png")
	self.birth = love.timer.getTime() + math.random( 0, 128 )
	self.size = math.random( 4, 6 )
	self.ang = 0
	self.falling = false
	self.health = 10
	self.maxhealth = self.health
	self.smokes = {}
	self.image_smoke = love.graphics.newImage("textures/smoke.png")
end

function ent:setPos( x, y )
	self.x = x
	self.y = y
	self.fixed_y = y
end

function ent:update(dt)
	self.y = self.fixed_y + math.sin(love.timer.getTime() - self.birth)*(self.size*3)
	self.x = self.x + (self.size*9)*dt
	
	if (self.x >= 850) then
	    takeScore(3)
		ents.Destroy( self.id )
	end
	
	if self.falling then
		self.fixed_y = self.fixed_y + 32*dt
		self.ang = self.ang + math.pi*0.025*dt
		
		if self.y >= 300 then
			startBGExplosion( self.x + 512*(self.size/20), self.y + 128*(self.size/20), 1 )
			self.falling = false
			ents.Destroy( self.id )
		end
	end
	
	for k, smoke in pairs(self.smokes) do
		smoke.time = smoke.time - dt
		if smoke.time <= 0 then
			table.remove( self.smokes, k )
		end
	end
end

function ent:Damage(n)
	if (n <= 0) or (self.falling) then return end
	ent:Smoke()
	self.health = self.health - n
	addScore(1)
	if self.health <= 0 then
		self.health = 0
		ent:Fall()
		addScore(3)
	end
end

function ent:Die()
	ents.Create( "lazar", -math.random(128, 256), 128, true )
end

function ent:Fall()
	self.falling = true
end

function ent:Smoke()
	table.insert( self.smokes, {time = 3, x = self.x, y = self.y} )
end

function ent:draw()
	love.graphics.setColor( 255, 255, 255, 255 )
	love.graphics.draw( self.image, self.x, self.y, self.ang, self.size/20, self.size/20, 0, 0 )
	
	for k, smoke in pairs(self.smokes) do
		local s = (smoke.time/3)
		love.graphics.setColor( 255, 255, 255, (s*255) )
		love.graphics.draw( self.image_smoke, smoke.x, smoke.y - (1-s)*64, 0, self.size/20, self.size/20, 0, 0 )
	end
end

return ent;