function load()
	require("states/example/entities")
	require("states/example/explosion")
	ents.Startup()
	love.graphics.setBackgroundColor( 255, 255, 255 )
	xCloud = 0
	imageCloud = love.graphics.newImage("textures/cloud.png")
	imageGround = love.graphics.newImage( "textures/ground.png" )
	imageCar = love.graphics.newImage("textures/car.png")
	imageMoon = love.graphics.newImage("textures/moon.png")
	xCar = 0
	
	score = 0
	
	for i = 1, 3 do
		ents.Create( "lazar", -math.random(128, 256), 128, true )
	end
	
	ents.Create( "ham", 0, 512, false )
end

function love.draw()
	local x = love.mouse.getX( )
	local y = love.mouse.getY( )
	
	love.graphics.setColor( 9, 72, 136, 255 )
	love.graphics.rectangle( "fill", 0, 0, 800, 300 )
	
	love.graphics.setColor( 255, 255, 255, 255 )
	love.graphics.draw( imageMoon, 50, 50, 0, 1, 1, 0, 0)
	love.graphics.draw( imageCloud, xCloud - 256, 50, 0, 1, 1, 0, 0 )
	
	
	drawBGExplosions()
	ents:drawBG()
	
	love.graphics.setColor( 140,140,140, 255 )
	love.graphics.rectangle( "fill", 0, 300, 800, 300 )
	
	love.graphics.setColor( 255, 255, 255, 255 )
	love.graphics.draw( imageCar, xCar - 180, 350, 0, 1, 1, 0, 0)
	
	
	
	
	love.graphics.draw( imageGround, (800-1024)/2, 300-64, 0, 1, 1, 0, 0 )
	
	
	
	ents:draw()
	
	love.graphics.setColor( 25, 25, 25, 255 )
	love.graphics.print( "Score: " .. score, 16, 16, 0, 1, 1 )
end

function love.update(dt)
	xCloud = xCloud + 32*dt
	if xCloud >= (800 + 256) then
		xCloud = 0
	end
	xCar = xCar + 64*dt
	if xCar >= (800 + 180) then
	     xCar = 0
    end
	updateBGExplosions(dt)
	ents:update(dt)
end

function love.focus(bool)
end

function love.keypressed( key, unicode )
end

function love.keyreleased( key, unicode )
	
end

function love.mousepressed( x, y, button )
	if button == "l" then
		ents.shoot( x, y )
	end
end

function love.mousereleased( x, y, button )
end

function love.quit()
end

function insideBox( px, py, x, y, wx, wy )
	if px > x and px < x + wx then
		if py > y and py < y + wy then
			return true
		end
	end
	return false
end

function addScore(n)
	score = score + tonumber(n)
end

function takeScore(n)
	score = score - tonumber(n)
	if score < -10 then
		love.event.quit()
	end
end