/*
 * Copyright (c) 2011-2014, ScalaFX Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the ScalaFX Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE SCALAFX PROJECT OR ITS CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package scalafx.scene.chart

import scalafx.application.JFXApp
import scalafx.collections.ObservableBuffer
import scalafx.scene.Scene

object StackedBarChartDemo extends JFXApp {

  val years = Seq("2007", "2008", "2009")

  val xAxis = CategoryAxis(ObservableBuffer(years))
  val yAxis = NumberAxis(
    axisLabel = "Units Sold",
    lowerBound = 0,
    upperBound = 8000,
    tickUnit = 1000
  )

  stage = new JFXApp.PrimaryStage {
    title = "StackedBarChartDemo"
    scene = new Scene {
      root = new StackedBarChart(xAxis, yAxis) {
        title = "Stacked Bar Chart"
        categoryGap = 25
        data = ObservableBuffer(
          xySeries("Region 1", Seq(567, 1292, 1290)),
          xySeries("Region 2", Seq(956, 1665, 2559)),
          xySeries("Region 3", Seq(1154, 1927, 2774))
        )
      }
    }
  }

  /** Create XYChart.Series from a sequence of numbers matching year strings. */
  def xySeries(name: String, data: Seq[Int]) = {
    val series = years zip data
    XYChart.Series[String, Number](
      name,
      ObservableBuffer(series.map {case (x, y) => XYChart.Data[String, Number](x, y)})
    )
  }
}
