/*
 * Copyright (c) 2011-2015, ScalaFX Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the ScalaFX Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE SCALAFX PROJECT OR ITS CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package scalafx.scene.shape

import javafx.scene.{shape => jfxss}

import scalafx.delegate.{SFXEnumDelegate, SFXEnumDelegateCompanion}

/** Wrapper for [[http://docs.oracle.com/javase/8/javafx/api/javafx/scene/shape/DrawMode.html javafx.scene.shape.DrawMode]] */
object DrawMode extends SFXEnumDelegateCompanion[jfxss.DrawMode, DrawMode] {

  /**
   * Render polygonal faces as solid surfaces.
   */
  val Fill = new DrawMode(jfxss.DrawMode.FILL)

  /**
   * Render polygonal faces as solid surfaces.
   */
  @deprecated("Use Fill instead; FILL will be removed in a future release.", "8.0.0-M4")
  val FILL = Fill

  /**
   * Render polygonal faces as wireframes, with lines linking consecutive vertices.
   */
  val Line = new DrawMode(jfxss.DrawMode.LINE)

  /**
   * Render polygonal faces as wireframes, with lines linking consecutive vertices.
   */
  @deprecated("Use Line instead; LINE will be removed in a future release.", "8.0.0-M4")
  val LINE = Line

  protected override def unsortedValues: Array[DrawMode] = Array(Fill, Line)
}


sealed case class DrawMode(override val delegate: jfxss.DrawMode)
  extends SFXEnumDelegate[jfxss.DrawMode]
