/*
 * Copyright (c) 2011-2014, ScalaFX Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the ScalaFX Project nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE SCALAFX PROJECT OR ITS CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package scalafx.testutil

import org.scalatest.Matchers._

import scalafx.delegate.AlignmentDelegate
import scalafx.delegate.AlignmentDelegate._
import scalafx.geometry.Pos

/**
 * Trait to test AlignmentDelegate subclasses
 */
trait AlignmentDelegateSpec[J <: Object with Aligned, D <: AlignmentDelegate[J]]
  extends SFXDelegateSpec[J, D] {

  it should "have its Alignment observed when changed" in {
    var changed = false
    val delegate = getScalaClassInstance
    val initialValue = Pos.BaselineCenter
    val finalValue = Pos.CenterRight

    delegate.alignment = initialValue
    val subscription = delegate.alignment.onChange((ov, oldValue, newValue) => {
      oldValue should be(initialValue.delegate)
      newValue should be(finalValue.delegate)
      changed = true
    })

    delegate.alignment = finalValue

    changed should be(true)
    delegate.alignment.value should be(finalValue.delegate)

    subscription.cancel()
  }

}