import json

try:
    with open("diplomirani.json", "r") as f:
        diplomirani = json.load(f)
except IOError:
    print("Greska pri ucitavanju datoteke!\n")
    exit(1)

sm = input()
try:
    pr = float(input())
except ValueError:
    print("Neispravan unos prosecne ocene!!!")
    exit(1)


dobarprosek = []
for e in diplomirani:
    if e["S"] == sm:
        if e["P"] >= pr:
            pr = e["P"]
            dobarprosek.append(e)
    
if len(dobarprosek) == 0:
    print("Nema odgovarajucih kandidata!")
    exit(0)
elif len(dobarprosek) > 1:
    asistenti = []
    min = 10
    for e in dobarprosek:
        if e["GodStudiranja"] < min:
            min = e["GodStudiranja"]

    if len(dobarprosek) > 1:
        for e in dobarprosek:
            if e["GodStudiranja"] <= min:
                asistenti.append(e)
    if len(asistenti) > 1:
        print("Potreban je dodatni intervju:") 
    dobarprosek = asistenti

for e in dobarprosek:
    print(e["Student"])