/*
Insertion sort algoritam se zasnima na ubacivanju redom svakog elementa liste na svoje mesto 
tako da se odrzi sortiran redosled. 

IH (Induktivna hipoteza) - umemo da sortiramo listu od n-1 elementa
IK (Induktivni korak) - ubacujemo n-ti element na odgovarajucu lokaciju u sortiranu listu

*/
insertionSort([],[]).
insertionSort([G|R], SL) :- insertionSort(R, S1), ubaciS(G, S1, SL).

% ubacuje element X u sortiranu listu tako da je rezultat sortirana lista %
ubaciS(X, [], [X]).
ubaciS(X, [G|R], [X, G|R]) :- X =< G, !.
ubaciS(X, [G|R], [G|SL]) :- ubaciS(X, R, SL).

/*
Merge sort algoritam se zasniva na dekompoziciji. Ulaznu listu delimo na polovine, njih sortiramo i objedinimo.

IH - sortiramo liste velicine n/2
IK - objedinjujemo dve sortirane liste od po n/2 elemenata

*/
mergeSort([], []) :- !.
mergeSort([X], [X]) :- !. 
mergeSort(N, SL) :- podeli(N, L, R), 
    mergeSort(L, L1), mergeSort(R, R1), 
    objedini(L1, R1, SL).

% ideja za deljenje - naizmenicno rasporedjujemo elemente u dve polovine %
podeli([], [], []). 
podeli([X], [X], []) :- !. 
podeli([G1, G2 | R], [G1 | R1], [G2 | R2]) :- podeli(R, R1, R2).

/*
Objedinjujemo sortirane liste u jednu.
*/
objedini(L, [], L). 
objedini([], L, L). 
objedini([G1|R1], [G2|R2], [G1|R]) :- G1 < G2, objedini(R1, [G2|R2], R), !.
objedini([G1|R1], [G2|R2], [G2|R]) :- objedini([G1|R1], R2, R).
